/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.mule.jgss.GSSCredentialImpl;
import sun.security.mule.jgss.GSSExceptionImpl;
import sun.security.mule.jgss.GSSHeader;
import sun.security.mule.jgss.GSSManagerImpl;
import sun.security.mule.jgss.GSSNameImpl;
import sun.security.mule.jgss.GSSUtil;
import sun.security.mule.jgss.ProviderList;
import sun.security.mule.jgss.krb5.Krb5Context;
import sun.security.mule.jgss.spi.GSSContextSpi;
import sun.security.mule.jgss.spi.GSSCredentialSpi;
import sun.security.mule.jgss.spi.GSSNameSpi;
import sun.security.util.ObjectIdentifier;

class GSSContextImpl
implements GSSContext {
    private GSSManagerImpl gssManager = null;
    private static final int PRE_INIT = 1;
    private static final int IN_PROGRESS = 2;
    private static final int READY = 3;
    private static final int DELETED = 4;
    private int currentState = 1;
    private boolean initiator;
    private GSSContextSpi mechCtxt = null;
    private Oid mechOid = null;
    private ObjectIdentifier objId = null;
    private GSSCredentialImpl myCred = null;
    private GSSCredentialImpl delegCred = null;
    private GSSNameImpl srcName = null;
    private GSSNameImpl targName = null;
    private int reqLifetime = Integer.MAX_VALUE;
    private ChannelBinding channelBindings = null;
    private boolean reqConfState = true;
    private boolean reqIntegState = true;
    private boolean reqMutualAuthState = true;
    private boolean reqReplayDetState = true;
    private boolean reqSequenceDetState = true;
    private boolean reqCredDelegState = false;
    private boolean reqAnonState = false;

    public GSSContextImpl(GSSManagerImpl gssManager, GSSName peer, Oid mech, GSSCredential myCred, int lifetime) throws GSSException {
        if (peer == null || !(peer instanceof GSSNameImpl)) {
            throw new GSSException(3);
        }
        if (mech == null) {
            mech = ProviderList.DEFAULT_MECH_OID;
        }
        this.gssManager = gssManager;
        this.myCred = (GSSCredentialImpl)myCred;
        this.reqLifetime = lifetime;
        this.targName = (GSSNameImpl)peer;
        this.mechOid = mech;
        this.initiator = true;
    }

    public GSSContextImpl(GSSManagerImpl gssManager, GSSCredential myCred) throws GSSException {
        this.gssManager = gssManager;
        this.myCred = (GSSCredentialImpl)myCred;
        this.initiator = false;
    }

    public GSSContextImpl(GSSManagerImpl gssManager, byte[] interProcessToken) throws GSSException {
        this.gssManager = gssManager;
        this.mechCtxt = gssManager.getMechanismContext(interProcessToken);
        this.initiator = this.mechCtxt.isInitiator();
        this.mechOid = this.mechCtxt.getMech();
    }

    @Override
    public byte[] initSecContext(byte[] inputBuf, int offset, int len) throws GSSException {
        ByteArrayInputStream bin = new ByteArrayInputStream(inputBuf, offset, len);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(600);
        int size = this.initSecContext(bin, bos);
        return size == 0 ? null : bos.toByteArray();
    }

    @Override
    public int initSecContext(InputStream inStream, OutputStream outStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to initSecContext");
        }
        GSSHeader gssHeader = null;
        int inTokenLen = -1;
        GSSCredentialSpi credElement = null;
        boolean firstToken = false;
        try {
            if (this.mechCtxt == null) {
                if (this.myCred != null) {
                    try {
                        credElement = this.myCred.getElement(this.mechOid, true);
                    }
                    catch (GSSException ge) {
                        if (GSSUtil.isSpNegoMech(this.mechOid) && ge.getMajor() == 13) {
                            credElement = this.myCred.getElement(this.myCred.getMechs()[0], true);
                        }
                        throw ge;
                    }
                }
                GSSNameSpi nameElement = this.targName.getElement(this.mechOid);
                this.mechCtxt = this.gssManager.getMechanismContext(nameElement, credElement, this.reqLifetime, this.mechOid);
                this.mechCtxt.requestConf(this.reqConfState);
                this.mechCtxt.requestInteg(this.reqIntegState);
                this.mechCtxt.requestCredDeleg(this.reqCredDelegState);
                this.mechCtxt.requestMutualAuth(this.reqMutualAuthState);
                this.mechCtxt.requestReplayDet(this.reqReplayDetState);
                this.mechCtxt.requestSequenceDet(this.reqSequenceDetState);
                this.mechCtxt.requestAnonymity(this.reqAnonState);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                if (this.mechCtxt instanceof Krb5Context && this.gssManager instanceof GSSManagerImpl) {
                    ((Krb5Context)this.mechCtxt).setKerberosConfig(this.gssManager.getKerberosConfig());
                }
                this.objId = new ObjectIdentifier(this.mechOid.toString());
                this.currentState = 2;
                firstToken = true;
            } else if (!this.mechCtxt.getProvider().getName().equals("SunNativeGSS") && !GSSUtil.isSpNegoMech(this.mechOid)) {
                gssHeader = new GSSHeader(inStream);
                if (!gssHeader.getOid().equals(this.objId)) {
                    throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in initSecContext token");
                }
                inTokenLen = gssHeader.getMechTokenLength();
            }
            byte[] obuf = this.mechCtxt.initSecContext(inStream, inTokenLen);
            int retVal = 0;
            if (obuf != null) {
                retVal = obuf.length;
                if (!(this.mechCtxt.getProvider().getName().equals("SunNativeGSS") || !firstToken && GSSUtil.isSpNegoMech(this.mechOid))) {
                    gssHeader = new GSSHeader(this.objId, obuf.length);
                    retVal += gssHeader.encode(outStream);
                }
                outStream.write(obuf);
            }
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
            return retVal;
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(10, e.getMessage());
        }
    }

    @Override
    public byte[] acceptSecContext(byte[] inTok, int offset, int len) throws GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100);
        this.acceptSecContext(new ByteArrayInputStream(inTok, offset, len), bos);
        return bos.toByteArray();
    }

    @Override
    public void acceptSecContext(InputStream inStream, OutputStream outStream) throws GSSException {
        if (this.mechCtxt != null && this.currentState != 2) {
            throw new GSSExceptionImpl(11, "Illegal call to acceptSecContext");
        }
        GSSHeader gssHeader = null;
        int inTokenLen = -1;
        GSSCredentialSpi credElement = null;
        try {
            if (this.mechCtxt == null) {
                gssHeader = new GSSHeader(inStream);
                inTokenLen = gssHeader.getMechTokenLength();
                this.objId = gssHeader.getOid();
                this.mechOid = new Oid(this.objId.toString());
                if (this.myCred != null) {
                    credElement = this.myCred.getElement(this.mechOid, false);
                }
                this.mechCtxt = this.gssManager.getMechanismContext(credElement, this.mechOid);
                this.mechCtxt.setChannelBinding(this.channelBindings);
                this.currentState = 2;
            } else if (!this.mechCtxt.getProvider().getName().equals("SunNativeGSS") && !GSSUtil.isSpNegoMech(this.mechOid)) {
                gssHeader = new GSSHeader(inStream);
                if (!gssHeader.getOid().equals(this.objId)) {
                    throw new GSSExceptionImpl(10, "Mechanism not equal to " + this.mechOid.toString() + " in acceptSecContext token");
                }
                inTokenLen = gssHeader.getMechTokenLength();
            }
            byte[] obuf = this.mechCtxt.acceptSecContext(inStream, inTokenLen);
            if (obuf != null) {
                int retVal = obuf.length;
                if (!this.mechCtxt.getProvider().getName().equals("SunNativeGSS") && !GSSUtil.isSpNegoMech(this.mechOid)) {
                    gssHeader = new GSSHeader(this.objId, obuf.length);
                    retVal += gssHeader.encode(outStream);
                }
                outStream.write(obuf);
            }
            if (this.mechCtxt.isEstablished()) {
                this.currentState = 3;
            }
        }
        catch (IOException e) {
            throw new GSSExceptionImpl(10, e.getMessage());
        }
    }

    @Override
    public boolean isEstablished() {
        if (this.mechCtxt == null) {
            return false;
        }
        return this.currentState == 3;
    }

    @Override
    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getWrapSizeLimit(qop, confReq, maxTokenSize);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    @Override
    public byte[] wrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.wrap(inBuf, offset, len, msgProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    @Override
    public void wrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.wrap(inStream, outStream, msgProp);
    }

    @Override
    public byte[] unwrap(byte[] inBuf, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.unwrap(inBuf, offset, len, msgProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    @Override
    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.unwrap(inStream, outStream, msgProp);
    }

    @Override
    public byte[] getMIC(byte[] inMsg, int offset, int len, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMIC(inMsg, offset, len, msgProp);
        }
        throw new GSSExceptionImpl(12, "No mechanism context yet!");
    }

    @Override
    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.getMIC(inStream, outStream, msgProp);
    }

    @Override
    public void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(inTok, tokOffset, tokLen, inMsg, msgOffset, msgLen, msgProp);
    }

    @Override
    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        this.mechCtxt.verifyMIC(tokStream, msgStream, msgProp);
    }

    @Override
    public byte[] export() throws GSSException {
        byte[] result = null;
        if (this.mechCtxt.isTransferable() && this.mechCtxt.getProvider().getName().equals("SunNativeGSS")) {
            result = this.mechCtxt.export();
        }
        return result;
    }

    @Override
    public void requestMutualAuth(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqMutualAuthState = state;
        }
    }

    @Override
    public void requestReplayDet(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqReplayDetState = state;
        }
    }

    @Override
    public void requestSequenceDet(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqSequenceDetState = state;
        }
    }

    @Override
    public void requestCredDeleg(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqCredDelegState = state;
        }
    }

    @Override
    public void requestAnonymity(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqAnonState = state;
        }
    }

    @Override
    public void requestConf(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqConfState = state;
        }
    }

    @Override
    public void requestInteg(boolean state) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqIntegState = state;
        }
    }

    @Override
    public void requestLifetime(int lifetime) throws GSSException {
        if (this.mechCtxt == null) {
            this.reqLifetime = lifetime;
        }
    }

    @Override
    public void setChannelBinding(ChannelBinding channelBindings) throws GSSException {
        if (this.mechCtxt == null) {
            this.channelBindings = channelBindings;
        }
    }

    @Override
    public boolean getCredDelegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getCredDelegState();
        }
        return this.reqCredDelegState;
    }

    @Override
    public boolean getMutualAuthState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMutualAuthState();
        }
        return this.reqMutualAuthState;
    }

    @Override
    public boolean getReplayDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getReplayDetState();
        }
        return this.reqReplayDetState;
    }

    @Override
    public boolean getSequenceDetState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getSequenceDetState();
        }
        return this.reqSequenceDetState;
    }

    @Override
    public boolean getAnonymityState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getAnonymityState();
        }
        return this.reqAnonState;
    }

    @Override
    public boolean isTransferable() throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isTransferable();
        }
        return false;
    }

    @Override
    public boolean isProtReady() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.isProtReady();
        }
        return false;
    }

    @Override
    public boolean getConfState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getConfState();
        }
        return this.reqConfState;
    }

    @Override
    public boolean getIntegState() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getIntegState();
        }
        return this.reqIntegState;
    }

    @Override
    public int getLifetime() {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getLifetime();
        }
        return this.reqLifetime;
    }

    @Override
    public GSSName getSrcName() throws GSSException {
        if (this.srcName == null) {
            this.srcName = GSSNameImpl.wrapElement(this.gssManager, this.mechCtxt.getSrcName());
        }
        return this.srcName;
    }

    @Override
    public GSSName getTargName() throws GSSException {
        if (this.targName == null) {
            this.targName = GSSNameImpl.wrapElement(this.gssManager, this.mechCtxt.getTargName());
        }
        return this.targName;
    }

    @Override
    public Oid getMech() throws GSSException {
        if (this.mechCtxt != null) {
            return this.mechCtxt.getMech();
        }
        return this.mechOid;
    }

    @Override
    public GSSCredential getDelegCred() throws GSSException {
        if (this.mechCtxt == null) {
            throw new GSSExceptionImpl(12, "No mechanism context yet!");
        }
        GSSCredentialSpi delCredElement = this.mechCtxt.getDelegCred();
        return delCredElement == null ? null : new GSSCredentialImpl(this.gssManager, delCredElement);
    }

    @Override
    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    @Override
    public void dispose() throws GSSException {
        this.currentState = 4;
        if (this.mechCtxt != null) {
            this.mechCtxt.dispose();
            this.mechCtxt = null;
        }
        this.myCred = null;
        this.srcName = null;
        this.targName = null;
    }
}

