/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss;

import java.util.LinkedList;
import org.ietf.jgss.MessageProp;

public class TokenTracker {
    static final int MAX_INTERVALS = 5;
    private int initNumber;
    private int windowStart;
    private int expectedNumber;
    private int windowStartIndex = 0;
    private LinkedList<Entry> list = new LinkedList();

    public TokenTracker(int initNumber) {
        this.initNumber = initNumber;
        this.windowStart = initNumber;
        this.expectedNumber = initNumber;
        Entry entry = new Entry(initNumber - 1);
        this.list.add(entry);
    }

    private int getIntervalIndex(int number) {
        int i;
        Entry entry = null;
        for (i = this.list.size() - 1; i >= 0 && (entry = this.list.get(i)).compareTo(number) > 0; --i) {
        }
        return i;
    }

    public final synchronized void getProps(int number, MessageProp prop) {
        boolean gap = false;
        boolean old = false;
        boolean unsequenced = false;
        boolean duplicate = false;
        int pos = this.getIntervalIndex(number);
        Entry entry = null;
        if (pos != -1) {
            entry = this.list.get(pos);
        }
        if (number == this.expectedNumber) {
            ++this.expectedNumber;
        } else if (entry != null && entry.contains(number)) {
            duplicate = true;
        } else if (this.expectedNumber >= this.initNumber) {
            if (number > this.expectedNumber) {
                gap = true;
            } else if (number >= this.windowStart) {
                unsequenced = true;
            } else if (number >= this.initNumber) {
                old = true;
            } else {
                gap = true;
            }
        } else if (number > this.expectedNumber) {
            if (number < this.initNumber) {
                gap = true;
            } else if (this.windowStart >= this.initNumber) {
                if (number >= this.windowStart) {
                    unsequenced = true;
                } else {
                    old = true;
                }
            } else {
                old = true;
            }
        } else if (this.windowStart > this.expectedNumber) {
            unsequenced = true;
        } else if (number < this.windowStart) {
            old = true;
        } else {
            unsequenced = true;
        }
        if (!duplicate && !old) {
            this.add(number, pos);
        }
        if (gap) {
            this.expectedNumber = number + 1;
        }
        prop.setSupplementaryStates(duplicate, old, unsequenced, gap, 0, null);
    }

    private void add(int number, int prevEntryPos) {
        Entry entry;
        int nextEntryPos;
        Entry entryBefore = null;
        Entry entryAfter = null;
        boolean appended = false;
        boolean prepended = false;
        if (prevEntryPos != -1 && number == (entryBefore = this.list.get(prevEntryPos)).getEnd() + 1) {
            entryBefore.setEnd(number);
            appended = true;
        }
        if ((nextEntryPos = prevEntryPos + 1) < this.list.size() && number == (entryAfter = this.list.get(nextEntryPos)).getStart() - 1) {
            if (!appended) {
                entryAfter.setStart(number);
            } else {
                entryAfter.setStart(entryBefore.getStart());
                this.list.remove(prevEntryPos);
                if (this.windowStartIndex > prevEntryPos) {
                    --this.windowStartIndex;
                }
            }
            prepended = true;
        }
        if (prepended || appended) {
            return;
        }
        if (this.list.size() < 5) {
            entry = new Entry(number);
            if (prevEntryPos < this.windowStartIndex) {
                ++this.windowStartIndex;
            }
        } else {
            int oldWindowStartIndex = this.windowStartIndex;
            if (this.windowStartIndex == this.list.size() - 1) {
                this.windowStartIndex = 0;
            }
            entry = this.list.remove(oldWindowStartIndex);
            this.windowStart = this.list.get(this.windowStartIndex).getStart();
            entry.setStart(number);
            entry.setEnd(number);
            if (prevEntryPos >= oldWindowStartIndex) {
                --prevEntryPos;
            } else if (oldWindowStartIndex != this.windowStartIndex) {
                if (prevEntryPos == -1) {
                    this.windowStart = number;
                }
            } else {
                ++this.windowStartIndex;
            }
        }
        this.list.add(prevEntryPos + 1, entry);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("TokenTracker: ");
        buf.append(" initNumber=").append(this.initNumber);
        buf.append(" windowStart=").append(this.windowStart);
        buf.append(" expectedNumber=").append(this.expectedNumber);
        buf.append(" windowStartIndex=").append(this.windowStartIndex);
        buf.append("\n\tIntervals are: {");
        for (int i = 0; i < this.list.size(); ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.list.get(i).toString());
        }
        buf.append('}');
        return buf.toString();
    }

    class Entry {
        private int start;
        private int end;

        Entry(int number) {
            this.start = number;
            this.end = number;
        }

        final int compareTo(int number) {
            if (this.start > number) {
                return 1;
            }
            if (this.end < number) {
                return -1;
            }
            return 0;
        }

        final boolean contains(int number) {
            return number >= this.start && number <= this.end;
        }

        final void append(int number) {
            if (number == this.end + 1) {
                this.end = number;
            }
        }

        final void setInterval(int start, int end) {
            this.start = start;
            this.end = end;
        }

        final void setEnd(int end) {
            this.end = end;
        }

        final void setStart(int start) {
            this.start = start;
        }

        final int getStart() {
            return this.start;
        }

        final int getEnd() {
            return this.end;
        }

        public String toString() {
            return "[" + this.start + ", " + this.end + "]";
        }
    }
}

