/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.krb5;

import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;
import sun.security.mule.jgss.krb5.InitialToken;
import sun.security.mule.jgss.krb5.Krb5Context;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbApRep;
import sun.security.mule.krb5.KrbApReq;
import sun.security.mule.krb5.KrbException;
import sun.security.util.DerValue;

class AcceptSecContextToken
extends InitialToken {
    private KrbApRep apRep = null;

    public AcceptSecContextToken(Krb5Context context, KrbApReq apReq, Config kerberosConfig) throws KrbException, IOException {
        boolean useSubkey = false;
        boolean useSequenceNumber = true;
        this.apRep = new KrbApRep(apReq, useSequenceNumber, useSubkey, kerberosConfig);
        context.resetMySequenceNumber(this.apRep.getSeqNumber());
    }

    public AcceptSecContextToken(Krb5Context context, Credentials serviceCreds, KrbApReq apReq, InputStream is, Config kerberosConfig) throws IOException, GSSException, KrbException {
        Integer apRepSeqNumber;
        int tokenId = is.read() << 8 | is.read();
        if (tokenId != 512) {
            throw new GSSException(10, -1, "AP_REP token id does not match!");
        }
        byte[] apRepBytes = new DerValue(is).toByteArray();
        KrbApRep apRep = new KrbApRep(apRepBytes, serviceCreds, apReq, kerberosConfig);
        EncryptionKey subKey = apRep.getSubKey();
        if (subKey != null) {
            context.setKey(subKey);
        }
        int peerSeqNumber = (apRepSeqNumber = apRep.getSeqNumber()) != null ? apRepSeqNumber : 0;
        context.resetPeerSequenceNumber(peerSeqNumber);
    }

    @Override
    public final byte[] encode() throws IOException {
        byte[] apRepBytes = this.apRep.getMessage();
        byte[] retVal = new byte[2 + apRepBytes.length];
        AcceptSecContextToken.writeInt(512, retVal, 0);
        System.arraycopy(apRepBytes, 0, retVal, 2, apRepBytes.length);
        return retVal;
    }
}

