/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.krb5;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SubjectComber {
    private static final Log logger = LogFactory.getLog(SubjectComber.class);

    private SubjectComber() {
    }

    static Object find(Subject subject, String serverPrincipal, String clientPrincipal, Class credClass) {
        return SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, true);
    }

    static Object findMany(Subject subject, String serverPrincipal, String clientPrincipal, Class credClass) {
        return SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findAux(Subject subject, String serverPrincipal, String clientPrincipal, Class credClass, boolean oneOnly) {
        ArrayList<Serializable> answer;
        if (subject == null) {
            return null;
        }
        ArrayList<Serializable> arrayList = answer = oneOnly ? null : new ArrayList<Serializable>();
        if (credClass == KerberosKey.class) {
            for (KerberosKey key : subject.getPrivateCredentials(KerberosKey.class)) {
                if (serverPrincipal != null && !serverPrincipal.equals(key.getPrincipal().getName())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found key for " + key.getPrincipal() + "(" + key.getKeyType() + ")"));
                }
                if (oneOnly) {
                    return key;
                }
                if (serverPrincipal == null) {
                    serverPrincipal = key.getPrincipal().getName();
                }
                answer.add(key);
            }
        } else if (credClass == KerberosTicket.class) {
            Set<Object> pcs;
            Set<Object> set = pcs = subject.getPrivateCredentials();
            synchronized (set) {
                Iterator<Object> iterator = pcs.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (!(obj instanceof KerberosTicket)) continue;
                    KerberosTicket ticket = (KerberosTicket)obj;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found ticket for " + ticket.getClient() + " to go to " + ticket.getServer() + " expiring on " + ticket.getEndTime()));
                    }
                    if (!ticket.isCurrent()) {
                        if (subject.isReadOnly()) continue;
                        iterator.remove();
                        try {
                            ticket.destroy();
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Removed and destroyed the expired Ticket \n" + ticket));
                        }
                        catch (DestroyFailedException dfe) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Expired ticket not detroyed successfully. " + dfe));
                        }
                        continue;
                    }
                    if (serverPrincipal != null && !ticket.getServer().getName().equals(serverPrincipal) || clientPrincipal != null && !clientPrincipal.equals(ticket.getClient().getName())) continue;
                    if (oneOnly) {
                        return ticket;
                    }
                    if (clientPrincipal == null) {
                        clientPrincipal = ticket.getClient().getName();
                    }
                    if (serverPrincipal == null) {
                        serverPrincipal = ticket.getServer().getName();
                    }
                    answer.add(ticket);
                }
            }
        }
        return answer;
    }
}

