/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.mule.jgss.GSSHeader;
import sun.security.mule.jgss.krb5.CipherHelper;
import sun.security.mule.jgss.krb5.Krb5Context;
import sun.security.mule.jgss.krb5.MessageToken_v2;
import sun.security.mule.krb5.Confounder;

class WrapToken_v2
extends MessageToken_v2 {
    static final int CONFOUNDER_SIZE = 16;
    private boolean readTokenFromInputStream = true;
    private InputStream is = null;
    private byte[] tokenBytes = null;
    private int tokenOffset = 0;
    private int tokenLen = 0;
    private byte[] dataBytes = null;
    private int dataOffset = 0;
    private int dataLen = 0;
    private int dataSize = 0;
    byte[] confounder = null;
    private boolean privacy = false;
    private boolean initiator = true;

    public WrapToken_v2(Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        super(1284, context, tokenBytes, tokenOffset, tokenLen, prop);
        this.readTokenFromInputStream = false;
        byte[] new_tokenBytes = new byte[tokenLen];
        if (this.rotate_left(tokenBytes, tokenOffset, new_tokenBytes, tokenLen)) {
            this.tokenBytes = new_tokenBytes;
            this.tokenOffset = 0;
        } else {
            this.tokenBytes = tokenBytes;
            this.tokenOffset = tokenOffset;
        }
        this.tokenLen = tokenLen;
        this.privacy = prop.getPrivacy();
        this.dataSize = tokenLen - 16;
        this.initiator = context.isInitiator();
    }

    public WrapToken_v2(Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        super(1284, context, is, prop);
        this.is = is;
        this.privacy = prop.getPrivacy();
        try {
            this.tokenLen = is.available();
        }
        catch (IOException e) {
            throw new GSSException(10, -1, WrapToken_v2.getTokenName(this.getTokenId()) + ": " + e.getMessage());
        }
        this.dataSize = this.tokenLen - 16;
        this.initiator = context.isInitiator();
    }

    public byte[] getData() throws GSSException {
        byte[] temp = new byte[this.dataSize];
        int len = this.getData(temp, 0);
        byte[] retVal = new byte[len];
        System.arraycopy(temp, 0, retVal, 0, retVal.length);
        return retVal;
    }

    public int getData(byte[] dataBuf, int dataBufOffset) throws GSSException {
        if (this.readTokenFromInputStream) {
            this.getDataFromStream(dataBuf, dataBufOffset);
        } else {
            this.getDataFromBuffer(dataBuf, dataBufOffset);
        }
        int retVal = 0;
        retVal = this.privacy ? this.dataSize - this.confounder.length - 16 - this.cipherHelper.getChecksumLength() : this.dataSize - this.cipherHelper.getChecksumLength();
        return retVal;
    }

    private void getDataFromBuffer(byte[] dataBuf, int dataBufOffset) throws GSSException {
        int dataPos = this.tokenOffset + 16;
        int data_length = 0;
        if (dataPos + this.dataSize > this.tokenOffset + this.tokenLen) {
            throw new GSSException(10, -1, "Insufficient data in " + WrapToken_v2.getTokenName(this.getTokenId()));
        }
        this.confounder = new byte[16];
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenBytes, dataPos, this.dataSize, dataBuf, dataBufOffset, this.getKeyUsage());
            data_length = this.dataSize - 16 - 16 - this.cipherHelper.getChecksumLength();
        } else {
            WrapToken_v2.debug("\t\tNo encryption was performed by peer.\n");
            data_length = this.dataSize - this.cipherHelper.getChecksumLength();
            System.arraycopy(this.tokenBytes, dataPos, dataBuf, dataBufOffset, data_length);
            if (!this.verifySign(dataBuf, dataBufOffset, data_length)) {
                throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
            }
        }
    }

    private void getDataFromStream(byte[] dataBuf, int dataBufOffset) throws GSSException {
        int data_length = 0;
        this.confounder = new byte[16];
        try {
            if (this.privacy) {
                this.cipherHelper.decryptData(this, this.is, this.dataSize, dataBuf, dataBufOffset, this.getKeyUsage());
                data_length = this.dataSize - 16 - 16 - this.cipherHelper.getChecksumLength();
            } else {
                WrapToken_v2.debug("\t\tNo encryption was performed by peer.\n");
                WrapToken_v2.readFully(this.is, this.confounder);
                data_length = this.dataSize - this.cipherHelper.getChecksumLength();
                WrapToken_v2.readFully(this.is, dataBuf, dataBufOffset, data_length);
                if (!this.verifySign(dataBuf, dataBufOffset, data_length)) {
                    throw new GSSException(6, -1, "Corrupt checksum in Wrap token");
                }
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, WrapToken_v2.getTokenName(this.getTokenId()) + ": " + e.getMessage());
        }
    }

    public WrapToken_v2(Krb5Context context, MessageProp prop, byte[] dataBytes, int dataOffset, int dataLen) throws GSSException {
        super(1284, context);
        this.confounder = Confounder.bytes(16);
        this.dataSize = this.confounder.length + dataLen + 16 + this.cipherHelper.getChecksumLength();
        this.dataBytes = dataBytes;
        this.dataOffset = dataOffset;
        this.dataLen = dataLen;
        this.initiator = context.isInitiator();
        this.genSignAndSeqNumber(prop, dataBytes, dataOffset, dataLen);
        if (!context.getConfState()) {
            prop.setPrivacy(false);
        }
        this.privacy = prop.getPrivacy();
    }

    @Override
    public void encode(OutputStream os) throws IOException, GSSException {
        super.encode(os);
        if (!this.privacy) {
            byte[] checksum = this.getChecksum(this.dataBytes, this.dataOffset, this.dataLen);
            os.write(this.dataBytes, this.dataOffset, this.dataLen);
            os.write(checksum);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), this.dataBytes, this.dataOffset, this.dataLen, this.getKeyUsage(), os);
        }
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.dataSize + 50);
        this.encode(bos);
        return bos.toByteArray();
    }

    public int encode(byte[] outToken, int offset) throws IOException, GSSException {
        int retVal = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        super.encode(bos);
        byte[] header = bos.toByteArray();
        System.arraycopy(header, 0, outToken, offset, header.length);
        offset += header.length;
        if (!this.privacy) {
            byte[] checksum = this.getChecksum(this.dataBytes, this.dataOffset, this.dataLen);
            System.arraycopy(this.dataBytes, this.dataOffset, outToken, offset, this.dataLen);
            System.arraycopy(checksum, 0, outToken, offset += this.dataLen, this.cipherHelper.getChecksumLength());
            retVal = header.length + this.dataLen + this.cipherHelper.getChecksumLength();
        } else {
            int cLen = this.cipherHelper.encryptData(this, this.confounder, this.getTokenHeader(), this.dataBytes, this.dataOffset, this.dataLen, outToken, offset, this.getKeyUsage());
            retVal = header.length + cLen;
        }
        return retVal;
    }

    @Override
    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize() + this.dataSize;
    }

    static int getSizeLimit(int qop, boolean confReq, int maxTokenSize, CipherHelper ch) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, maxTokenSize) - (WrapToken_v2.getTokenSize(ch) + 16) - 8;
    }
}

