/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.spnego;

import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.mule.jgss.GSSManagerImpl;
import sun.security.mule.jgss.GSSUtil;
import sun.security.mule.jgss.SunProvider;
import sun.security.mule.jgss.krb5.Krb5AcceptCredential;
import sun.security.mule.jgss.krb5.Krb5InitCredential;
import sun.security.mule.jgss.krb5.Krb5MechFactory;
import sun.security.mule.jgss.krb5.Krb5NameElement;
import sun.security.mule.jgss.spi.GSSContextSpi;
import sun.security.mule.jgss.spi.GSSCredentialSpi;
import sun.security.mule.jgss.spi.GSSNameSpi;
import sun.security.mule.jgss.spi.MechanismFactory;
import sun.security.mule.jgss.spnego.SpNegoContext;
import sun.security.mule.jgss.spnego.SpNegoCredElement;
import sun.security.mule.krb5.Config;

public final class SpNegoMechFactory
implements MechanismFactory {
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_SPNEGO_MECH_OID = GSSUtil.createOid("1.3.6.1.5.5.2");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME};
    final GSSManagerImpl manager;
    final Oid[] availableMechs;

    private static SpNegoCredElement getCredFromSubject(GSSNameSpi name, boolean initiate) throws GSSException {
        GSSCredentialSpi cred;
        SpNegoCredElement result;
        Vector creds = GSSUtil.searchSubject(name, GSS_SPNEGO_MECH_OID, initiate, SpNegoCredElement.class);
        SpNegoCredElement spNegoCredElement = result = creds == null || creds.isEmpty() ? null : (SpNegoCredElement)creds.firstElement();
        if (result != null && GSSUtil.isKerberosMech((cred = result.getInternalCred()).getMechanism())) {
            if (initiate) {
                Krb5InitCredential krbCred = (Krb5InitCredential)cred;
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)krbCred.getName());
            } else {
                Krb5AcceptCredential krbCred = (Krb5AcceptCredential)cred;
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)krbCred.getName(), name);
            }
        }
        return result;
    }

    public SpNegoMechFactory(int caller, Config kerberosConfig) {
        this.manager = new GSSManagerImpl(caller, false, kerberosConfig);
        Oid[] mechs = this.manager.getMechs();
        this.availableMechs = new Oid[mechs.length - 1];
        int j = 0;
        for (int i = 0; i < mechs.length; ++i) {
            if (mechs[i].equals(GSS_SPNEGO_MECH_OID)) continue;
            this.availableMechs[j++] = mechs[i];
        }
    }

    @Override
    public GSSNameSpi getNameElement(String nameStr, Oid nameType) throws GSSException {
        return this.manager.getNameElement(nameStr, nameType, null);
    }

    @Override
    public GSSNameSpi getNameElement(byte[] name, Oid nameType) throws GSSException {
        return this.manager.getNameElement(name, nameType, null);
    }

    @Override
    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        SpNegoCredElement credElement = SpNegoMechFactory.getCredFromSubject(name, usage != 2);
        if (credElement == null) {
            credElement = new SpNegoCredElement(this.manager.getCredentialElement(name, initLifetime, acceptLifetime, null, usage));
        }
        return credElement;
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myInitiatorCred, int lifetime) throws GSSException {
        if (myInitiatorCred == null) {
            myInitiatorCred = SpNegoMechFactory.getCredFromSubject(null, true);
        } else if (!(myInitiatorCred instanceof SpNegoCredElement)) {
            SpNegoCredElement cred = new SpNegoCredElement(myInitiatorCred);
            return new SpNegoContext(this, peer, cred, lifetime);
        }
        return new SpNegoContext(this, peer, myInitiatorCred, lifetime);
    }

    @Override
    public GSSContextSpi getMechanismContext(GSSCredentialSpi myAcceptorCred) throws GSSException {
        if (myAcceptorCred == null) {
            myAcceptorCred = SpNegoMechFactory.getCredFromSubject(null, false);
        } else if (!(myAcceptorCred instanceof SpNegoCredElement)) {
            SpNegoCredElement cred = new SpNegoCredElement(myAcceptorCred);
            return new SpNegoContext(this, cred);
        }
        return new SpNegoContext(this, myAcceptorCred);
    }

    @Override
    public GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        return new SpNegoContext(this, exportedContext);
    }

    @Override
    public final Oid getMechanismOid() {
        return GSS_SPNEGO_MECH_OID;
    }

    @Override
    public Provider getProvider() {
        return PROVIDER;
    }

    @Override
    public Oid[] getNameTypes() {
        return nameTypes;
    }
}

