/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import sun.security.action.GetPropertyAction;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbAsRep;
import sun.security.mule.krb5.KrbAsReq;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbTgsReq;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.ServiceName;
import sun.security.mule.krb5.internal.CredentialsUtil;
import sun.security.mule.krb5.internal.HostAddresses;
import sun.security.mule.krb5.internal.KDCOptions;
import sun.security.mule.krb5.internal.KRBError;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.TicketFlags;
import sun.security.mule.krb5.internal.ccache.CredentialsCache;
import sun.security.mule.krb5.internal.crypto.EType;
import sun.security.mule.krb5.internal.ktab.KeyTab;

public class Credentials {
    Ticket ticket;
    PrincipalName client;
    PrincipalName server;
    EncryptionKey key;
    TicketFlags flags;
    KerberosTime authTime;
    KerberosTime startTime;
    KerberosTime endTime;
    KerberosTime renewTill;
    HostAddresses cAddr;
    EncryptionKey serviceKey;
    private static boolean DEBUG = Krb5.DEBUG;
    private static CredentialsCache cache;
    static boolean alreadyLoaded;
    private static boolean alreadyTried;

    private static native Credentials acquireDefaultNativeCreds();

    public Credentials(Ticket new_ticket, PrincipalName new_client, PrincipalName new_server, EncryptionKey new_key, TicketFlags new_flags, KerberosTime authTime, KerberosTime new_startTime, KerberosTime new_endTime, KerberosTime renewTill, HostAddresses cAddr) {
        this.ticket = new_ticket;
        this.client = new_client;
        this.server = new_server;
        this.key = new_key;
        this.flags = new_flags;
        this.authTime = authTime;
        this.startTime = new_startTime;
        this.endTime = new_endTime;
        this.renewTill = renewTill;
        this.cAddr = cAddr;
    }

    public Credentials(byte[] encoding, String client, String server, byte[] keyBytes, int keyType, boolean[] flags, Date authTime, Date startTime, Date endTime, Date renewTill, InetAddress[] cAddrs, Config kerberosConfig) throws KrbException, IOException {
        this(new Ticket(encoding), new PrincipalName(client, 1, kerberosConfig), new PrincipalName(server, 2, kerberosConfig), new EncryptionKey(keyType, keyBytes), flags == null ? null : new TicketFlags(flags), authTime == null ? null : new KerberosTime(authTime, kerberosConfig), startTime == null ? null : new KerberosTime(startTime, kerberosConfig), endTime == null ? null : new KerberosTime(endTime, kerberosConfig), renewTill == null ? null : new KerberosTime(renewTill, kerberosConfig), null);
    }

    public final PrincipalName getClient() {
        return this.client;
    }

    public final PrincipalName getServer() {
        return this.server;
    }

    public final EncryptionKey getSessionKey() {
        return this.key;
    }

    public final Date getAuthTime() {
        if (this.authTime != null) {
            return this.authTime.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.renewTill != null) {
            return this.renewTill.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.flags == null) {
            return null;
        }
        return this.flags.toBooleanArray();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.cAddr == null) {
            return null;
        }
        return this.cAddr.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] retVal;
        block4: {
            retVal = null;
            try {
                retVal = this.ticket.asn1Encode();
            }
            catch (Asn1Exception e) {
                if (DEBUG) {
                    System.out.println(e);
                }
            }
            catch (IOException ioe) {
                if (!DEBUG) break block4;
                System.out.println(ioe);
            }
        }
        return retVal;
    }

    public boolean isForwardable() {
        return this.flags.get(1);
    }

    public boolean isRenewable() {
        return this.flags.get(8);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public boolean checkDelegate() {
        return this.flags.get(13);
    }

    public Credentials renew(Config kerberosConfig) throws KrbException, IOException {
        KDCOptions options = new KDCOptions(kerberosConfig);
        options.set(30, true);
        options.set(8, true);
        return new KrbTgsReq(options, this, this.server, null, null, null, null, this.cAddr, null, null, null, kerberosConfig).sendAndGetCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName princ, String ticketCache) throws KrbException, IOException {
        String os;
        if (ticketCache == null && (os = AccessController.doPrivileged(new GetPropertyAction("os.name"))).toUpperCase().startsWith("WINDOWS")) {
            Credentials creds = Credentials.acquireDefaultCreds();
            if (creds == null) {
                if (DEBUG) {
                    System.out.println(">>> Found no TGT's in LSA");
                }
                return null;
            }
            if (princ != null) {
                if (creds.getClient().equals(princ)) {
                    if (DEBUG) {
                        System.out.println(">>> Obtained TGT from LSA: " + creds);
                    }
                    return creds;
                }
                if (DEBUG) {
                    System.out.println(">>> LSA contains TGT for " + creds.getClient() + " not " + princ);
                }
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> Obtained TGT from LSA: " + creds);
            }
            return creds;
        }
        CredentialsCache ccache = CredentialsCache.getInstance(princ, ticketCache);
        if (ccache == null) {
            return null;
        }
        sun.security.mule.krb5.internal.ccache.Credentials tgtCred = ccache.getDefaultCreds();
        if (EType.isSupported(tgtCred.getEType())) {
            return tgtCred.setKrbCreds();
        }
        if (DEBUG) {
            System.out.println(">>> unsupported key type found the default TGT: " + tgtCred.getEType());
        }
        return null;
    }

    public static Credentials acquireTGT(PrincipalName princ, EncryptionKey[] secretKeys, char[] password, Config kerberosConfig) throws KrbException, IOException {
        if (princ == null) {
            throw new IllegalArgumentException("Cannot have null principal to do AS-Exchange");
        }
        if (secretKeys == null) {
            throw new IllegalArgumentException("Cannot have null secretKey to do AS-Exchange");
        }
        KrbAsRep asRep = null;
        try {
            asRep = Credentials.sendASRequest(princ, secretKeys, null, kerberosConfig);
        }
        catch (KrbException ke) {
            if (ke.returnCode() == 24 || ke.returnCode() == 25) {
                KRBError error;
                byte[] newSalt;
                if (DEBUG) {
                    System.out.println("AcquireTGT: PREAUTH FAILED/REQUIRED, re-send AS-REQ");
                }
                if ((newSalt = (error = ke.getError()).getSalt()) != null && newSalt.length > 0) {
                    princ.setSalt(new String(newSalt));
                }
                if (password != null) {
                    secretKeys = EncryptionKey.acquireSecretKeys(password, princ.getSalt(), true, error.getEType(), error.getParams(), kerberosConfig);
                }
                asRep = Credentials.sendASRequest(princ, secretKeys, ke.getError(), kerberosConfig);
            }
            throw ke;
        }
        return asRep.getCreds();
    }

    private static KrbAsRep sendASRequest(PrincipalName princ, EncryptionKey[] secretKeys, KRBError error, Config kerberosConfig) throws KrbException, IOException {
        KrbAsReq asReq = null;
        asReq = error == null ? new KrbAsReq(princ, secretKeys, kerberosConfig) : new KrbAsReq(princ, secretKeys, true, error.getEType(), error.getSalt(), error.getParams(), kerberosConfig);
        String kdc = null;
        KrbAsRep asRep = null;
        try {
            kdc = asReq.send();
            asRep = asReq.getReply(secretKeys);
        }
        catch (KrbException ke) {
            if (ke.returnCode() == 52) {
                asReq.send(princ.getRealmString(), kdc, true, kerberosConfig);
                asRep = asReq.getReply(secretKeys);
            }
            throw ke;
        }
        return asRep;
    }

    public static synchronized Credentials acquireDefaultCreds() {
        Credentials result = null;
        if (cache == null) {
            cache = CredentialsCache.getInstance();
        }
        if (cache != null) {
            sun.security.mule.krb5.internal.ccache.Credentials temp;
            if (DEBUG) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            if (EType.isSupported((temp = cache.getDefaultCreds()).getEType())) {
                result = temp.setKrbCreds();
            } else if (DEBUG) {
                System.out.println(">>> unsupported key type found the default TGT: " + temp.getEType());
            }
        }
        if (result == null) {
            if (!alreadyTried) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception e) {
                    if (DEBUG) {
                        System.out.println("Can not load credentials cache");
                        e.printStackTrace();
                    }
                    alreadyTried = true;
                }
            }
            if (alreadyLoaded) {
                if (DEBUG) {
                    System.out.println(">> Acquire default native Credentials");
                }
                result = Credentials.acquireDefaultNativeCreds();
            }
        }
        return result;
    }

    public static Credentials getServiceCreds(String serviceName, File keyTabFile, Config kerberosConfig) {
        EncryptionKey k = null;
        PrincipalName service = null;
        Credentials result = null;
        try {
            service = new PrincipalName(serviceName, kerberosConfig);
            if (service.getRealm() == null) {
                String realm = kerberosConfig.getDefaultRealm();
                if (realm == null) {
                    return null;
                }
                service.setRealm(realm);
            }
        }
        catch (RealmException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        catch (KrbException e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        KeyTab kt = keyTabFile == null ? KeyTab.getInstance(kerberosConfig) : KeyTab.getInstance(keyTabFile, kerberosConfig);
        if (kt != null && kt.findServiceEntry(service)) {
            k = kt.readServiceKey(service);
            result = new Credentials(null, service, null, null, null, null, null, null, null, null);
            result.serviceKey = k;
        }
        return result;
    }

    public static Credentials acquireServiceCreds(String service, Credentials ccreds, Config kerberosConfig) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(service, ccreds, kerberosConfig);
    }

    private static Credentials serviceCreds(ServiceName service, Credentials ccreds, Config kerberosConfig) throws KrbException, IOException {
        return new KrbTgsReq(new KDCOptions(kerberosConfig), ccreds, service, null, null, null, null, null, null, null, null, kerberosConfig).sendAndGetCreds();
    }

    public CredentialsCache getCache() {
        return cache;
    }

    public EncryptionKey getServiceKey() {
        return this.serviceKey;
    }

    public static void printDebug(Credentials c) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + c.client.toString());
        System.out.println("\tserver: " + c.server.toString());
        System.out.println("\tticket: realm: " + c.ticket.realm.toString());
        System.out.println("\t        sname: " + c.ticket.sname.toString());
        if (c.startTime != null) {
            System.out.println("\tstartTime: " + c.startTime.getTime());
        }
        System.out.println("\tendTime: " + c.endTime.getTime());
        System.out.println("        ----Credentials end----");
    }

    static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("w2k_lsa_auth");
                return null;
            }
        });
        alreadyLoaded = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Credentials:");
        buffer.append("\nclient=").append(this.client);
        buffer.append("\nserver=").append(this.server);
        if (this.authTime != null) {
            buffer.append("\nauthTime=").append(this.authTime);
        }
        if (this.startTime != null) {
            buffer.append("\nstartTime=").append(this.startTime);
        }
        buffer.append("\nendTime=").append(this.endTime);
        buffer.append("\nrenewTill=").append(this.renewTill);
        buffer.append("\nflags: ").append(this.flags);
        buffer.append("\nEType (int): ").append(this.key.getEType());
        return buffer.toString();
    }

    static {
        alreadyLoaded = false;
        alreadyTried = false;
    }
}

