/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Confounder;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.ccache.CCacheOutputStream;
import sun.security.mule.krb5.internal.crypto.Aes128;
import sun.security.mule.krb5.internal.crypto.Aes256;
import sun.security.mule.krb5.internal.crypto.ArcFourHmac;
import sun.security.mule.krb5.internal.crypto.Des;
import sun.security.mule.krb5.internal.crypto.Des3;
import sun.security.mule.krb5.internal.crypto.EType;
import sun.security.mule.krb5.internal.ktab.KeyTab;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncryptionKey
implements Cloneable {
    public static final EncryptionKey NULL_KEY = new EncryptionKey(new byte[0], 0, null);
    private int keyType;
    private byte[] keyValue;
    private Integer kvno;
    private static final Log logger = LogFactory.getLog(EncryptionKey.class);

    public synchronized int getEType() {
        return this.keyType;
    }

    public final Integer getKeyVersionNumber() {
        return this.kvno;
    }

    public final byte[] getBytes() {
        return this.keyValue;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.keyValue, this.keyType, this.kvno);
    }

    public static EncryptionKey[] acquireSecretKeys(PrincipalName princ, String keytab, Config kerberosConfig) throws KrbException, IOException {
        if (princ == null) {
            throw new IllegalArgumentException("Cannot have null pricipal name to look in keytab.");
        }
        KeyTab ktab = KeyTab.getInstance(keytab, kerberosConfig);
        if (ktab == null) {
            return null;
        }
        return ktab.readServiceKeys(princ, kerberosConfig);
    }

    public static EncryptionKey[] acquireSecretKeys(char[] password, String salt, Config kerberosConfig) throws KrbException {
        return EncryptionKey.acquireSecretKeys(password, salt, false, 0, null, kerberosConfig);
    }

    public static EncryptionKey[] acquireSecretKeys(char[] password, String salt, boolean pa_exists, int pa_etype, byte[] pa_s2kparams, Config kerberosConfig) throws KrbException {
        int[] etypes = EType.getDefaults("default_tkt_enctypes", kerberosConfig);
        if (etypes == null) {
            etypes = EType.getBuiltInDefaults();
        }
        if (pa_exists && pa_etype != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pre-Authentication: Set preferred etype = " + pa_etype));
            }
            if (EType.isSupported(pa_etype)) {
                etypes = new int[]{pa_etype};
            }
        }
        EncryptionKey[] encKeys = new EncryptionKey[etypes.length];
        for (int i = 0; i < etypes.length; ++i) {
            if (EType.isSupported(etypes[i])) {
                encKeys[i] = new EncryptionKey(EncryptionKey.stringToKey(password, salt, pa_s2kparams, etypes[i]), etypes[i], null);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Encryption Type " + EType.toString(etypes[i]) + " is not supported/enabled"));
        }
        return encKeys;
    }

    public EncryptionKey(byte[] keyValue, int keyType, Integer kvno) {
        if (keyValue == null) {
            throw new IllegalArgumentException("EncryptionKey: Key bytes cannot be null!");
        }
        this.keyValue = new byte[keyValue.length];
        System.arraycopy(keyValue, 0, this.keyValue, 0, keyValue.length);
        this.keyType = keyType;
        this.kvno = kvno;
    }

    public EncryptionKey(int keyType, byte[] keyValue) {
        this(keyValue, keyType, null);
    }

    private static byte[] stringToKey(char[] password, String salt, byte[] s2kparams, int keyType) throws KrbCryptoException {
        char[] slt = salt.toCharArray();
        char[] pwsalt = new char[password.length + slt.length];
        System.arraycopy(password, 0, pwsalt, 0, password.length);
        System.arraycopy(slt, 0, pwsalt, password.length, slt.length);
        Arrays.fill(slt, '0');
        try {
            switch (keyType) {
                case 1: 
                case 3: {
                    byte[] byArray = Des.string_to_key_bytes(pwsalt);
                    return byArray;
                }
                case 16: {
                    byte[] byArray = Des3.stringToKey(pwsalt);
                    return byArray;
                }
                case 23: {
                    byte[] byArray = ArcFourHmac.stringToKey(password);
                    return byArray;
                }
                case 17: {
                    byte[] byArray = Aes128.stringToKey(password, salt, s2kparams);
                    return byArray;
                }
                case 18: {
                    byte[] byArray = Aes256.stringToKey(password, salt, s2kparams);
                    return byArray;
                }
            }
            try {
                throw new IllegalArgumentException("encryption type " + EType.toString(keyType) + " not supported");
            }
            catch (GeneralSecurityException e) {
                KrbCryptoException ke = new KrbCryptoException(e.getMessage());
                ke.initCause(e);
                throw ke;
            }
        }
        finally {
            Arrays.fill(pwsalt, '0');
        }
    }

    public EncryptionKey(char[] password, String salt, String algorithm) throws KrbCryptoException {
        if (algorithm == null || algorithm.equalsIgnoreCase("DES")) {
            this.keyType = 3;
        } else if (algorithm.equalsIgnoreCase("DESede")) {
            this.keyType = 16;
        } else if (algorithm.equalsIgnoreCase("AES128")) {
            this.keyType = 17;
        } else if (algorithm.equalsIgnoreCase("ArcFourHmac")) {
            this.keyType = 23;
        } else if (algorithm.equalsIgnoreCase("AES256")) {
            this.keyType = 18;
            if (!EType.isSupported(this.keyType)) {
                throw new IllegalArgumentException("Algorithm " + algorithm + " not enabled");
            }
        } else {
            throw new IllegalArgumentException("Algorithm " + algorithm + " not supported");
        }
        this.keyValue = EncryptionKey.stringToKey(password, salt, null, this.keyType);
        this.kvno = null;
    }

    EncryptionKey(EncryptionKey key) throws KrbCryptoException {
        this.keyValue = Confounder.bytes(key.keyValue.length);
        for (int i = 0; i < this.keyValue.length; ++i) {
            int n = i;
            this.keyValue[n] = (byte)(this.keyValue[n] ^ key.keyValue[i]);
        }
        this.keyType = key.keyType;
        try {
            if (this.keyType == 3 || this.keyType == 1) {
                if (!DESKeySpec.isParityAdjusted(this.keyValue, 0)) {
                    this.keyValue = Des.set_parity(this.keyValue);
                }
                if (DESKeySpec.isWeak(this.keyValue, 0)) {
                    this.keyValue[7] = (byte)(this.keyValue[7] ^ 0xF0);
                }
            }
            if (this.keyType == 16) {
                if (!DESedeKeySpec.isParityAdjusted(this.keyValue, 0)) {
                    this.keyValue = Des3.parityFix(this.keyValue);
                }
                byte[] oneKey = new byte[8];
                for (int i = 0; i < this.keyValue.length; i += 8) {
                    System.arraycopy(this.keyValue, i, oneKey, 0, 8);
                    if (!DESKeySpec.isWeak(oneKey, 0)) continue;
                    this.keyValue[i + 7] = (byte)(this.keyValue[i + 7] ^ 0xF0);
                }
            }
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public EncryptionKey(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.keyType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.keyValue = der.getData().getOctetString();
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.keyType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.keyValue);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public synchronized void destroy() {
        if (this.keyValue != null) {
            for (int i = 0; i < this.keyValue.length; ++i) {
                this.keyValue[i] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new EncryptionKey(subDer);
    }

    public synchronized void writeKey(CCacheOutputStream cos) throws IOException {
        cos.write16(this.keyType);
        cos.write16(this.keyType);
        cos.write32(this.keyValue.length);
        for (int i = 0; i < this.keyValue.length; ++i) {
            cos.write8(this.keyValue[i]);
        }
    }

    public String toString() {
        return new String("EncryptionKey: keyType=" + this.keyType + " kvno=" + this.kvno + " keyValue (hex dump)=" + (this.keyValue == null || this.keyValue.length == 0 ? " Empty Key" : '\n' + Krb5.hexDumper.encode(this.keyValue) + '\n'));
    }

    public static EncryptionKey findKey(int etype, EncryptionKey[] keys) throws KrbException {
        int ktype;
        int i;
        if (!EType.isSupported(etype)) {
            throw new KrbException("Encryption type " + EType.toString(etype) + " is not supported/enabled");
        }
        for (i = 0; i < keys.length; ++i) {
            ktype = keys[i].getEType();
            if (!EType.isSupported(ktype) || etype != ktype) continue;
            return keys[i];
        }
        if (etype == 1 || etype == 3) {
            for (i = 0; i < keys.length; ++i) {
                ktype = keys[i].getEType();
                if (ktype != 1 && ktype != 3) continue;
                return new EncryptionKey(etype, keys[i].getBytes());
            }
        }
        return null;
    }
}

