/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbAsRep;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbKdcReq;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.ASReq;
import sun.security.mule.krb5.internal.HostAddresses;
import sun.security.mule.krb5.internal.KDCOptions;
import sun.security.mule.krb5.internal.KDCReqBody;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.PAData;
import sun.security.mule.krb5.internal.PAEncTSEnc;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.crypto.EType;
import sun.security.mule.krb5.internal.crypto.Nonce;

public class KrbAsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private ASReq asReqMessg;
    private boolean DEBUG = Krb5.DEBUG;
    private boolean PA_ENC_TIMESTAMP_REQUIRED = false;
    private boolean pa_exists = false;
    private int pa_etype = 0;
    private byte[] pa_salt = null;
    private byte[] pa_s2kparams = null;
    private Config kerberosConfig;
    private boolean KDC_EMPTY_ADDRESSES_ALLOWED = true;

    KrbAsReq(PrincipalName principal, EncryptionKey[] keys, Config kerberosConfig) throws KrbException, IOException {
        this(keys, false, 0, null, null, new KDCOptions(kerberosConfig), principal, null, null, null, null, null, null, null, kerberosConfig);
    }

    KrbAsReq(PrincipalName principal, EncryptionKey[] keys, boolean pa_exists, int etype, byte[] salt, byte[] s2kparams, Config kerberosConfig) throws KrbException, IOException {
        this(keys, pa_exists, etype, salt, s2kparams, new KDCOptions(kerberosConfig), principal, null, null, null, null, null, null, null, kerberosConfig);
    }

    private static int[] getETypesFromKeys(EncryptionKey[] keys) {
        int[] types = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            types[i] = keys[i].getEType();
        }
        return types;
    }

    public void updatePA(int etype, byte[] salt, byte[] params, PrincipalName name) {
        this.pa_exists = true;
        this.pa_etype = etype;
        this.pa_salt = salt;
        this.pa_s2kparams = params;
        if (salt != null && salt.length > 0) {
            String newSalt = new String(salt);
            name.setSalt(newSalt);
            if (this.DEBUG) {
                System.out.println("Updated salt from pre-auth = " + name.getSalt());
            }
        }
        this.PA_ENC_TIMESTAMP_REQUIRED = true;
    }

    public KrbAsReq(char[] password, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws KrbException, IOException {
        this(password, false, 0, null, null, options, cname, sname, from, till, rtime, eTypes, addresses, additionalTickets, kerberosConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsReq(char[] password, boolean pa_exists, int etype, byte[] salt, byte[] s2kparams, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws KrbException, IOException {
        EncryptionKey[] keys = null;
        if (pa_exists) {
            this.updatePA(etype, salt, s2kparams, cname);
        }
        if (password != null) {
            keys = EncryptionKey.acquireSecretKeys(password, cname.getSalt(), pa_exists, this.pa_etype, this.pa_s2kparams, kerberosConfig);
        }
        if (this.DEBUG) {
            System.out.println(">>>KrbAsReq salt is " + cname.getSalt());
        }
        try {
            this.init(keys, options, cname, sname, from, till, rtime, eTypes, addresses, additionalTickets, kerberosConfig);
        }
        finally {
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    keys[i].destroy();
                }
            }
        }
    }

    public KrbAsReq(EncryptionKey[] keys, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws KrbException, IOException {
        this(keys, false, 0, null, null, options, cname, sname, from, till, rtime, eTypes, addresses, additionalTickets, kerberosConfig);
    }

    public KrbAsReq(EncryptionKey[] keys, boolean pa_exists, int etype, byte[] salt, byte[] s2kparams, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws KrbException, IOException {
        if (pa_exists) {
            this.updatePA(etype, salt, s2kparams, cname);
            if (this.DEBUG) {
                System.out.println(">>>KrbAsReq salt is " + cname.getSalt());
            }
        }
        this.init(keys, options, cname, sname, from, till, rtime, eTypes, addresses, additionalTickets, kerberosConfig);
    }

    private void init(EncryptionKey[] keys, KDCOptions options, PrincipalName cname, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws KrbException, IOException {
        if (options.get(2) || options.get(4) || options.get(28) || options.get(30) || options.get(31)) {
            throw new KrbException(101);
        }
        if (!options.get(6) && from != null) {
            from = null;
        }
        if (!options.get(8) && rtime != null) {
            rtime = null;
        }
        this.princName = cname;
        this.kerberosConfig = kerberosConfig;
        EncryptionKey key = null;
        int[] tktETypes = null;
        if (this.pa_exists && this.pa_etype != 0) {
            if (this.DEBUG) {
                System.out.println("Pre-Authenticaton: find key for etype = " + this.pa_etype);
            }
            key = EncryptionKey.findKey(this.pa_etype, keys);
            tktETypes = new int[]{this.pa_etype};
        } else {
            tktETypes = EType.getDefaults("default_tkt_enctypes", keys, kerberosConfig);
            key = EncryptionKey.findKey(tktETypes[0], keys);
        }
        PAData[] paData = null;
        if (this.PA_ENC_TIMESTAMP_REQUIRED) {
            if (this.DEBUG) {
                System.out.println("AS-REQ: Add PA_ENC_TIMESTAMP now");
            }
            PAEncTSEnc ts = new PAEncTSEnc(kerberosConfig);
            byte[] temp = ts.asn1Encode();
            if (key != null) {
                EncryptedData encTs = new EncryptedData(key, temp, 1);
                paData = new PAData[]{new PAData(2, encTs.asn1Encode())};
            }
        }
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq calling createMessage");
        }
        if (eTypes == null) {
            eTypes = tktETypes;
        }
        if (kerberosConfig.useAddresses()) {
            this.KDC_EMPTY_ADDRESSES_ALLOWED = false;
        }
        if (addresses == null && !this.KDC_EMPTY_ADDRESSES_ALLOWED) {
            addresses = HostAddresses.getLocalAddresses();
        }
        this.asReqMessg = this.createMessage(paData, options, cname, cname.getRealm(), sname, from, till, rtime, eTypes, addresses, additionalTickets, kerberosConfig);
        this.obuf = this.asReqMessg.asn1Encode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KrbAsRep getReply(char[] password) throws KrbException, IOException {
        if (password == null) {
            throw new KrbException(400);
        }
        KrbAsRep temp = null;
        EncryptionKey[] keys = null;
        try {
            keys = EncryptionKey.acquireSecretKeys(password, this.princName.getSalt(), this.pa_exists, this.pa_etype, this.pa_s2kparams, this.kerberosConfig);
            temp = this.getReply(keys);
        }
        finally {
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    keys[i].destroy();
                }
            }
        }
        return temp;
    }

    public String send() throws IOException, KrbException {
        String realmStr = null;
        if (this.princName != null) {
            realmStr = this.princName.getRealmString();
        }
        return this.send(realmStr, this.kerberosConfig);
    }

    public KrbAsRep getReply(EncryptionKey[] keys) throws KrbException, IOException {
        return new KrbAsRep(this.ibuf, keys, this, this.kerberosConfig);
    }

    private ASReq createMessage(PAData[] paData, KDCOptions kdc_options, PrincipalName cname, Realm crealm, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, Ticket[] additionalTickets, Config kerberosConfig) throws Asn1Exception, KrbApErrException, RealmException, UnknownHostException, IOException {
        if (this.DEBUG) {
            System.out.println(">>> KrbAsReq in createMessage");
        }
        PrincipalName req_sname = null;
        if (sname == null) {
            if (crealm == null) {
                throw new RealmException(601, "default realm not specified ");
            }
            req_sname = new PrincipalName("krbtgt/" + crealm.toString(), 2, kerberosConfig);
        } else {
            req_sname = sname;
        }
        KerberosTime req_till = null;
        req_till = till == null ? new KerberosTime(kerberosConfig) : till;
        KDCReqBody kdc_req_body = new KDCReqBody(kdc_options, cname, crealm, req_sname, from, req_till, rtime, Nonce.value(), eTypes, addresses, null, additionalTickets, kerberosConfig);
        return new ASReq(paData, kdc_req_body);
    }

    ASReq getMessage() {
        return this.asReqMessg;
    }
}

