/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.TCPClient;
import sun.security.mule.krb5.internal.UDPClient;

public abstract class KrbKdcReq {
    private static final int DEFAULT_KDC_PORT = 88;
    private static final int DEFAULT_KDC_RETRY_LIMIT = 3;
    public static final int DEFAULT_KDC_TIMEOUT;
    private static final boolean DEBUG;
    private static int udpPrefLimit;
    protected byte[] obuf;
    protected byte[] ibuf;

    public static void initializeDefaults() {
    }

    public String send(String realm, Config kerberosConfig) throws IOException, KrbException {
        boolean useTCP = udpPrefLimit > 0 && this.obuf != null && this.obuf.length > udpPrefLimit;
        return this.send(realm, useTCP, kerberosConfig);
    }

    public String send(String realm, boolean useTCP, Config kerberosConfig) throws IOException, KrbException {
        if (this.obuf == null) {
            return null;
        }
        Exception savedException = null;
        Config cfg = kerberosConfig;
        if (realm == null && (realm = cfg.getDefaultRealm()) == null) {
            throw new KrbException(60, "Cannot find default realm");
        }
        int timeout = this.getKdcTimeout(realm, kerberosConfig);
        String kdcList = cfg.getKDCList(realm);
        if (kdcList == null) {
            throw new KrbException("Cannot get kdc for realm " + realm);
        }
        String tempKdc = null;
        StringTokenizer st = new StringTokenizer(kdcList);
        while (st.hasMoreTokens()) {
            tempKdc = st.nextToken();
            try {
                this.send(realm, tempKdc, useTCP, kerberosConfig);
                break;
            }
            catch (Exception e) {
                savedException = e;
            }
        }
        if (this.ibuf == null && savedException != null) {
            if (savedException instanceof IOException) {
                throw (IOException)savedException;
            }
            throw (KrbException)savedException;
        }
        return tempKdc;
    }

    public void send(String realm, String tempKdc, boolean useTCP, Config kerberosConfig) throws IOException, KrbException {
        String portStr;
        int tempPort;
        if (this.obuf == null) {
            return;
        }
        Object savedException = null;
        int port = 88;
        int timeout = this.getKdcTimeout(realm, kerberosConfig);
        StringTokenizer strTok = new StringTokenizer(tempKdc, ":");
        String kdc = strTok.nextToken();
        if (strTok.hasMoreTokens() && (tempPort = KrbKdcReq.parsePositiveIntString(portStr = strTok.nextToken())) > 0) {
            port = tempPort;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: kdc=" + kdc + (useTCP ? " TCP:" : " UDP:") + port + ", timeout=" + timeout + ", number of retries =" + 3 + ", #bytes=" + this.obuf.length);
        }
        KdcCommunication kdcCommunication = new KdcCommunication(kdc, port, useTCP, timeout, this.obuf);
        try {
            this.ibuf = AccessController.doPrivileged(kdcCommunication);
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
            }
        }
        catch (PrivilegedActionException e) {
            Exception wrappedException = e.getException();
            if (wrappedException instanceof IOException) {
                throw (IOException)wrappedException;
            }
            throw (KrbException)wrappedException;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: #bytes read=" + (this.ibuf != null ? this.ibuf.length : 0));
        }
    }

    private int getKdcTimeout(String realm, Config kerberosConfig) {
        int timeout = DEFAULT_KDC_TIMEOUT;
        if (realm == null) {
            return timeout;
        }
        int tempTimeout = -1;
        try {
            String temp = kerberosConfig.getDefault("kdc_timeout", realm);
            tempTimeout = KrbKdcReq.parsePositiveIntString(temp);
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (tempTimeout > 0) {
            timeout = tempTimeout;
        }
        return timeout;
    }

    private static int parsePositiveIntString(String intString) {
        if (intString == null) {
            return -1;
        }
        int ret = -1;
        try {
            ret = Integer.parseInt(intString);
        }
        catch (Exception exc) {
            return -1;
        }
        if (ret >= 0) {
            return ret;
        }
        return -1;
    }

    static {
        DEBUG = Krb5.DEBUG;
        udpPrefLimit = -1;
        int timeout = -1;
        DEFAULT_KDC_TIMEOUT = timeout > 0 ? timeout : 30000;
    }

    private static class KdcCommunication
    implements PrivilegedExceptionAction<byte[]> {
        private String kdc;
        private int port;
        private boolean useTCP;
        private int timeout;
        private byte[] obuf;

        public KdcCommunication(String kdc, int port, boolean useTCP, int timeout, byte[] obuf) {
            this.kdc = kdc;
            this.port = port;
            this.useTCP = useTCP;
            this.timeout = timeout;
            this.obuf = obuf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] run() throws IOException, KrbException {
            byte[] ibuf = null;
            if (this.useTCP) {
                TCPClient kdcClient = new TCPClient(this.kdc, this.port);
                try {
                    kdcClient.send(this.obuf);
                    ibuf = kdcClient.receive();
                }
                finally {
                    kdcClient.close();
                }
            }
            for (int i = 1; i <= 3; ++i) {
                UDPClient kdcClient = new UDPClient(this.kdc, this.port, this.timeout);
                if (DEBUG) {
                    System.out.println(">>> KDCCommunication: kdc=" + this.kdc + (this.useTCP ? " TCP:" : " UDP:") + this.port + ", timeout=" + this.timeout + ",Attempt =" + i + ", #bytes=" + this.obuf.length);
                }
                kdcClient.send(this.obuf);
                try {
                    ibuf = kdcClient.receive();
                    kdcClient.close();
                    break;
                }
                catch (SocketTimeoutException se) {
                    try {
                        if (DEBUG) {
                            System.out.println("SocketTimeOutException with attempt: " + i);
                        }
                        if (i != 3) continue;
                        ibuf = null;
                        throw se;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        kdcClient.close();
                    }
                }
            }
            return ibuf;
        }
    }
}

