/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Checksum;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbAppMessage;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.KRBSafe;
import sun.security.mule.krb5.internal.KRBSafeBody;
import sun.security.mule.krb5.internal.KdcErrException;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.SeqNumber;

class KrbSafe
extends KrbAppMessage {
    private byte[] obuf;
    private byte[] userData;
    private Config kerberosConfig;

    public KrbSafe(byte[] userData, Credentials creds, EncryptionKey subKey, KerberosTime timestamp, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr, Config kerberosConfig) throws KrbException, IOException {
        this.kerberosConfig = kerberosConfig;
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.obuf = this.mk_safe(userData, reqKey, timestamp, seqNumber, saddr, raddr);
    }

    public KrbSafe(byte[] msg, Credentials creds, EncryptionKey subKey, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr, boolean timestampRequired, boolean seqNumberRequired, Config kerberosConfig) throws KrbException, IOException {
        this.kerberosConfig = kerberosConfig;
        KRBSafe krb_safe = new KRBSafe(msg);
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.userData = this.rd_safe(krb_safe, reqKey, seqNumber, saddr, raddr, timestampRequired, seqNumberRequired, creds.client, creds.client.getRealm());
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public byte[] getData() {
        return this.userData;
    }

    private byte[] mk_safe(byte[] userData, EncryptionKey key, KerberosTime timestamp, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, KrbCryptoException {
        Integer usec = null;
        Integer seqno = null;
        if (timestamp != null) {
            usec = new Integer(timestamp.getMicroSeconds());
        }
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
            seqNumber.step();
        }
        KRBSafeBody krb_safeBody = new KRBSafeBody(userData, timestamp, usec, seqno, sAddress, rAddress, this.kerberosConfig);
        byte[] temp = krb_safeBody.asn1Encode();
        Checksum cksum = new Checksum(-999, temp, key, 15, this.kerberosConfig);
        KRBSafe krb_safe = new KRBSafe(krb_safeBody, cksum);
        temp = krb_safe.asn1Encode();
        return krb_safe.asn1Encode();
    }

    private byte[] rd_safe(KRBSafe krb_safe, EncryptionKey key, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress, boolean timestampRequired, boolean seqNumberRequired, PrincipalName cname, Realm crealm) throws Asn1Exception, KdcErrException, KrbApErrException, IOException, KrbCryptoException {
        byte[] temp = krb_safe.safeBody.asn1Encode();
        if (!krb_safe.cksum.verifyKeyedChecksum(temp, key, 15)) {
            throw new KrbApErrException(41);
        }
        this.check(krb_safe.safeBody.timestamp, krb_safe.safeBody.usec, krb_safe.safeBody.seqNumber, krb_safe.safeBody.sAddress, krb_safe.safeBody.rAddress, seqNumber, sAddress, rAddress, timestampRequired, seqNumberRequired, cname, crealm);
        return krb_safe.safeBody.userData;
    }
}

