/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbKdcRep;
import sun.security.mule.krb5.KrbTgsReq;
import sun.security.mule.krb5.internal.EncTGSRepPart;
import sun.security.mule.krb5.internal.KRBError;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.TGSRep;
import sun.security.mule.krb5.internal.TGSReq;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.ccache.Credentials;
import sun.security.util.DerValue;

public class KrbTgsRep
extends KrbKdcRep {
    private TGSRep rep;
    private sun.security.mule.krb5.Credentials creds;
    private Ticket secondTicket;
    private static final boolean DEBUG = Krb5.DEBUG;

    KrbTgsRep(byte[] ibuf, KrbTgsReq tgsReq, Config kerberosConfig) throws KrbException, IOException {
        DerValue ref = new DerValue(ibuf);
        TGSReq req = tgsReq.getMessage();
        TGSRep rep = null;
        try {
            rep = new TGSRep(ref);
        }
        catch (Asn1Exception e) {
            rep = null;
            KRBError err = new KRBError(ref, kerberosConfig);
            String errStr = err.getErrorString();
            String eText = null;
            if (errStr != null && errStr.length() > 0) {
                eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            }
            KrbException ke = eText == null ? new KrbException(err.getErrorCode()) : new KrbException(err.getErrorCode(), eText);
            ke.initCause(e);
            throw ke;
        }
        byte[] enc_tgs_rep_bytes = rep.encPart.decrypt(tgsReq.tgsReqKey, tgsReq.usedSubkey() ? 9 : 8);
        byte[] enc_tgs_rep_part = rep.encPart.reset(enc_tgs_rep_bytes, true);
        ref = new DerValue(enc_tgs_rep_part);
        EncTGSRepPart enc_part = new EncTGSRepPart(ref, kerberosConfig);
        rep.ticket.sname.setRealm(rep.ticket.realm);
        rep.encKDCRepPart = enc_part;
        KrbTgsRep.check(req, rep);
        this.creds = new sun.security.mule.krb5.Credentials(rep.ticket, req.reqBody.cname, rep.ticket.sname, enc_part.key, enc_part.flags, enc_part.authtime, enc_part.starttime, enc_part.endtime, enc_part.renewTill, enc_part.caddr);
        this.rep = rep;
        this.creds = this.creds;
        this.secondTicket = tgsReq.getSecondTicket();
    }

    public sun.security.mule.krb5.Credentials getCreds() {
        return this.creds;
    }

    Credentials setCredentials() {
        return new Credentials(this.rep, this.secondTicket);
    }
}

