/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.cxf;

import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.spnego.DefaultSpnegoClientAction;
import org.apache.ws.security.spnego.DefaultSpnegoServiceAction;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.apache.ws.security.spnego.SpnegoServiceAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.mule.tools.cxf.utils.security.XRMSpnegoClientAction;
import sun.security.mule.jgss.krb5.Krb5NameElement;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.login.Kerberos5LoginModule;

public class SpnegoTokenContext {
    private static final Log LOG = LogFactory.getLog(SpnegoTokenContext.class);
    private GSSContext secContext;
    private byte[] token;
    private boolean mutualAuth;
    private SpnegoClientAction clientAction = new DefaultSpnegoClientAction();
    private SpnegoServiceAction serviceAction = new DefaultSpnegoServiceAction();
    private Config kerberosConfig;

    public void setKerberosConfig(Config kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
    }

    public void retrieveServiceTicket(CallbackHandler callbackHandler, String serviceName) throws WSSecurityException {
        Subject clientSubject;
        Set<Principal> clientPrincipals;
        if (this.kerberosConfig == null) {
            String msg = "Trying to retrieve a service ticket without having suplied a Kerberos Configuration";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msg);
            }
            throw new WSSecurityException(msg);
        }
        Kerberos5LoginModule krb5Login = new Kerberos5LoginModule();
        Subject subject = new Subject();
        HashMap sharedState = new HashMap();
        HashMap options = new HashMap();
        krb5Login.initialize(subject, callbackHandler, sharedState, options, this.kerberosConfig);
        try {
            krb5Login.login();
            krb5Login.commit();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully authenticated to the TGT");
        }
        if ((clientPrincipals = (clientSubject = subject).getPrincipals()).isEmpty()) {
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
        }
        Krb5NameElement krb5Name = null;
        try {
            krb5Name = Krb5NameElement.getInstance(serviceName, null, this.kerberosConfig);
        }
        catch (GSSException e) {
            throw new WSSecurityException(0, "kerberosServiceTicketError - Cannot create the Krb5NameElement");
        }
        String principalName = krb5Name.getKrb5PrincipalName().getName();
        this.kerberosConfig.storeSubject(principalName, clientSubject);
        XRMSpnegoClientAction myClientAction = new XRMSpnegoClientAction(this.kerberosConfig);
        myClientAction.setServiceName(serviceName);
        myClientAction.setMutualAuth(this.mutualAuth);
        this.token = myClientAction.run();
        if (this.token == null) {
            throw new WSSecurityException(0, "kerberosServiceTicketError");
        }
        this.secContext = myClientAction.getContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully retrieved a service ticket");
        }
    }

    public void validateServiceTicket(String jaasLoginModuleName, CallbackHandler callbackHandler, String serviceName, byte[] ticket) throws WSSecurityException {
        LoginContext loginContext = null;
        try {
            loginContext = callbackHandler == null ? new LoginContext(jaasLoginModuleName) : new LoginContext(jaasLoginModuleName, callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully authenticated to the TGT");
        }
        Subject subject = loginContext.getSubject();
        String service = serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        this.serviceAction.setTicket(ticket);
        this.serviceAction.setServiceName(service);
        this.token = (byte[])Subject.doAs(subject, this.serviceAction);
        this.secContext = this.serviceAction.getContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully validated a service ticket");
        }
    }

    public void setMutualAuth(boolean mutualAuthentication) {
        this.mutualAuth = mutualAuthentication;
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean isEstablished() {
        if (this.secContext == null) {
            return false;
        }
        return this.secContext.isEstablished();
    }

    public byte[] unwrapKey(byte[] secret) throws WSSecurityException {
        MessageProp mProp = new MessageProp(0, true);
        try {
            return this.secContext.unwrap(secret, 0, secret.length, mProp);
        }
        catch (GSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
            throw new WSSecurityException(0, "spnegoKeyError");
        }
    }

    public byte[] wrapKey(byte[] secret) throws WSSecurityException {
        MessageProp mProp = new MessageProp(0, true);
        try {
            return this.secContext.wrap(secret, 0, secret.length, mProp);
        }
        catch (GSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
            throw new WSSecurityException(0, "spnegoKeyError");
        }
    }

    public void setSpnegoClientAction(SpnegoClientAction spnegoClientAction) {
        this.clientAction = spnegoClientAction;
    }

    public void setSpnegoServiceAction(SpnegoServiceAction spnegoServiceAction) {
        this.serviceAction = spnegoServiceAction;
    }

    public void clear() {
        block2: {
            this.token = null;
            this.mutualAuth = false;
            this.kerberosConfig = null;
            try {
                this.secContext.dispose();
            }
            catch (GSSException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
        }
    }
}

