/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbTgsReq;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.ServiceName;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbApErrException;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireServiceCreds(String service, Credentials ccreds, Config kerberosConfig) throws KrbException, IOException {
        ServiceName sname = new ServiceName(service, kerberosConfig);
        String serviceRealm = sname.getRealmString();
        String localRealm = ccreds.getClient().getRealmString();
        String defaultRealm = kerberosConfig.getDefaultRealm();
        if (localRealm == null) {
            PrincipalName temp = null;
            temp = ccreds.getServer();
            if (temp != null) {
                localRealm = temp.getRealmString();
            }
        }
        if (localRealm == null) {
            localRealm = defaultRealm;
        }
        if (serviceRealm == null) {
            serviceRealm = localRealm;
            sname.setRealm(serviceRealm);
        }
        if (localRealm.equals(serviceRealm)) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: same realm");
            }
            return CredentialsUtil.serviceCreds(sname, ccreds, kerberosConfig);
        }
        String[] realms = Realm.getRealmsList(localRealm, serviceRealm, kerberosConfig);
        if (realms == null || realms.length == 0) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: no realms list");
            }
            return null;
        }
        int i = 0;
        int k = 0;
        Credentials cTgt = null;
        Credentials newTgt = null;
        Credentials theTgt = null;
        ServiceName tempService = null;
        Object realm = null;
        String newTgtRealm = null;
        String theTgtRealm = null;
        cTgt = ccreds;
        i = 0;
        while (i < realms.length) {
            tempService = new ServiceName("krbtgt", serviceRealm, realms[i]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + i + "] tempService=" + tempService);
            }
            try {
                newTgt = CredentialsUtil.serviceCreds(tempService, cTgt, kerberosConfig);
            }
            catch (Exception exc) {
                newTgt = null;
            }
            if (newTgt == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching backwards");
                }
                newTgt = null;
                for (k = realms.length - 1; newTgt == null && k > i; --k) {
                    tempService = new ServiceName("krbtgt", realms[k], realms[i]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + k + "] tempService=" + tempService);
                    }
                    try {
                        newTgt = CredentialsUtil.serviceCreds(tempService, cTgt, kerberosConfig);
                        continue;
                    }
                    catch (Exception exc) {
                        newTgt = null;
                    }
                }
            }
            if (newTgt == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            newTgtRealm = newTgt.getServer().getInstanceComponent();
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (newTgtRealm.equals(serviceRealm)) {
                theTgt = newTgt;
                theTgtRealm = newTgtRealm;
                break;
            }
            for (k = i + 1; k < realms.length && !newTgtRealm.equals(realms[k]); ++k) {
            }
            if (k >= realms.length) break;
            i = k;
            cTgt = newTgt;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + i);
        }
        Credentials theCreds = null;
        if (theTgt != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got right tgt");
                System.out.println(">>> Credentials acquireServiceCreds: obtaining service creds for " + sname);
            }
            try {
                theCreds = CredentialsUtil.serviceCreds(sname, theTgt, kerberosConfig);
            }
            catch (Exception exc) {
                if (DEBUG) {
                    System.out.println(exc);
                }
                theCreds = null;
            }
        }
        if (theCreds != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: returning creds:");
                Credentials.printDebug(theCreds);
            }
            return theCreds;
        }
        throw new KrbApErrException(63, "No service creds");
    }

    private static Credentials serviceCreds(ServiceName service, Credentials ccreds, Config kerberosConfig) throws KrbException, IOException {
        return new KrbTgsReq(ccreds, service, kerberosConfig).sendAndGetCreds();
    }
}

