/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class ETypeInfo2 {
    private int etype;
    private String saltStr = null;
    private byte[] s2kparams = null;
    private static final byte TAG_TYPE = 0;
    private static final byte TAG_VALUE1 = 1;
    private static final byte TAG_VALUE2 = 2;

    private ETypeInfo2() {
    }

    public ETypeInfo2(int etype, byte[] salt, byte[] s2kparams) {
        this.etype = etype;
        if (salt != null) {
            this.saltStr = new String(salt);
        }
        if (s2kparams != null) {
            this.s2kparams = (byte[])s2kparams.clone();
        }
    }

    public Object clone() {
        ETypeInfo2 etypeInfo2 = new ETypeInfo2();
        etypeInfo2.etype = this.etype;
        etypeInfo2.saltStr = this.saltStr;
        if (this.s2kparams != null) {
            etypeInfo2.s2kparams = new byte[this.s2kparams.length];
            System.arraycopy(this.s2kparams, 0, etypeInfo2.s2kparams, 0, this.s2kparams.length);
        }
        return etypeInfo2;
    }

    public ETypeInfo2(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.etype = der.getData().getBigInteger().intValue();
        if (encoding.getData().available() > 0 && ((der = encoding.getData().getDerValue()).getTag() & 0x1F) == 1) {
            this.saltStr = der.getData().getGeneralString();
        }
        if (encoding.getData().available() > 0 && ((der = encoding.getData().getDerValue()).getTag() & 0x1F) == 2) {
            this.s2kparams = der.getData().getOctetString();
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.etype);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.saltStr != null) {
            temp = new DerOutputStream();
            temp.putGeneralString(this.saltStr);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        if (this.s2kparams != null) {
            temp = new DerOutputStream();
            temp.putOctetString(this.s2kparams);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public int getEType() {
        return this.etype;
    }

    public byte[] getSalt() {
        return this.saltStr == null ? null : this.saltStr.getBytes();
    }

    public byte[] getParams() {
        return this.s2kparams == null ? null : (byte[])this.s2kparams.clone();
    }
}

