/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncKrbPrivPart {
    public byte[] userData = null;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;
    private Config kerberosConfig;

    public EncKrbPrivPart(byte[] new_userData, KerberosTime new_timestamp, Integer new_usec, Integer new_seqNumber, HostAddress new_sAddress, HostAddress new_rAddress, Config kerberosConfig) {
        if (new_userData != null) {
            this.userData = (byte[])new_userData.clone();
        }
        this.timestamp = new_timestamp;
        this.usec = new_usec;
        this.seqNumber = new_seqNumber;
        this.sAddress = new_sAddress;
        this.rAddress = new_rAddress;
        this.kerberosConfig = kerberosConfig;
    }

    public EncKrbPrivPart(byte[] data, Config kerberosConfig) throws Asn1Exception, IOException {
        this.kerberosConfig = kerberosConfig;
        this.init(new DerValue(data));
    }

    public EncKrbPrivPart(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
        this.kerberosConfig = kerberosConfig;
        this.init(encoding);
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException {
        if ((encoding.getTag() & 0x1F) != 28 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.userData = subDer.getData().getOctetString();
        this.timestamp = KerberosTime.parse(der.getData(), (byte)1, true, this.kerberosConfig);
        if ((der.getData().peekByte() & 0x1F) == 2) {
            subDer = der.getData().getDerValue();
            this.usec = new Integer(subDer.getData().getBigInteger().intValue());
        } else {
            this.usec = null;
        }
        if ((der.getData().peekByte() & 0x1F) == 3) {
            subDer = der.getData().getDerValue();
            this.seqNumber = new Integer(subDer.getData().getBigInteger().intValue());
        } else {
            this.seqNumber = null;
        }
        this.sAddress = HostAddress.parse(der.getData(), (byte)4, false);
        if (der.getData().available() > 0) {
            this.rAddress = HostAddress.parse(der.getData(), (byte)5, true);
        }
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream temp = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        temp.putOctetString(this.userData);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.timestamp != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.usec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        }
        if (this.seqNumber != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)3), temp);
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)5), this.rAddress.asn1Encode());
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)28), temp);
        return bytes.toByteArray();
    }
}

