/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBSafeBody {
    public byte[] userData = null;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;
    private Config kerberosConfig;

    public KRBSafeBody(byte[] new_userData, KerberosTime new_timestamp, Integer new_usec, Integer new_seqNumber, HostAddress new_sAddress, HostAddress new_rAddress, Config kerberosConfig) {
        if (new_userData != null) {
            this.userData = (byte[])new_userData.clone();
        }
        this.timestamp = new_timestamp;
        this.usec = new_usec;
        this.seqNumber = new_seqNumber;
        this.sAddress = new_sAddress;
        this.rAddress = new_rAddress;
        this.kerberosConfig = kerberosConfig;
    }

    public KRBSafeBody(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.userData = der.getData().getOctetString();
        this.timestamp = KerberosTime.parse(encoding.getData(), (byte)1, true, this.kerberosConfig);
        if ((encoding.getData().peekByte() & 0x1F) == 2) {
            der = encoding.getData().getDerValue();
            this.usec = new Integer(der.getData().getBigInteger().intValue());
        }
        if ((encoding.getData().peekByte() & 0x1F) == 3) {
            der = encoding.getData().getDerValue();
            this.seqNumber = new Integer(der.getData().getBigInteger().intValue());
        }
        this.sAddress = HostAddress.parse(encoding.getData(), (byte)4, false);
        if (encoding.getData().available() > 0) {
            this.rAddress = HostAddress.parse(encoding.getData(), (byte)5, true);
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putOctetString(this.userData);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.timestamp != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.usec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        }
        if (this.seqNumber != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.seqNumber.longValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)3), temp);
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            temp = new DerOutputStream();
        }
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static KRBSafeBody parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new KRBSafeBody(subDer);
    }
}

