/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class MethodData {
    private int methodType;
    private byte[] methodData = null;

    public MethodData(int type, byte[] data) {
        this.methodType = type;
        if (data != null) {
            this.methodData = (byte[])data.clone();
        }
    }

    public MethodData(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        BigInteger bint = der.getData().getBigInteger();
        this.methodType = bint.intValue();
        if (encoding.getData().available() > 0) {
            der = encoding.getData().getDerValue();
            if ((der.getTag() & 0x1F) == 1) {
                this.methodData = der.getData().getOctetString();
            } else {
                throw new Asn1Exception(906);
            }
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.methodType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        if (this.methodData != null) {
            temp = new DerOutputStream();
            temp.putOctetString(this.methodData);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }
}

