/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAEncTSEnc {
    public KerberosTime pATimeStamp;
    public Integer pAUSec;
    private Config kerberosConfig;

    public PAEncTSEnc(KerberosTime new_pATimeStamp, Integer new_pAUSec, Config kerberosConfig) {
        this.pATimeStamp = new_pATimeStamp;
        this.pAUSec = new_pAUSec;
        this.kerberosConfig = kerberosConfig;
    }

    public PAEncTSEnc(Config kerberosConfig) {
        KerberosTime now;
        this.kerberosConfig = kerberosConfig;
        this.pATimeStamp = now = new KerberosTime(true, kerberosConfig);
        this.pAUSec = new Integer(now.getMicroSeconds());
    }

    public PAEncTSEnc(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
        this.kerberosConfig = kerberosConfig;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.pATimeStamp = KerberosTime.parse(encoding.getData(), (byte)0, false, kerberosConfig);
        if (encoding.getData().available() > 0) {
            DerValue der = encoding.getData().getDerValue();
            if ((der.getTag() & 0x1F) == 1) {
                this.pAUSec = new Integer(der.getData().getBigInteger().intValue());
            } else {
                throw new Asn1Exception(906);
            }
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), this.pATimeStamp.asn1Encode());
        if (this.pAUSec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.pAUSec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }
}

