/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPClient {
    InetAddress iaddr;
    int iport;
    int bufSize = 65507;
    DatagramSocket dgSocket;
    DatagramPacket dgPacketIn;

    public UDPClient(InetAddress newIAddr, int port) throws SocketException {
        this.iaddr = newIAddr;
        this.iport = port;
        this.dgSocket = new DatagramSocket();
    }

    public UDPClient(String hostname, int port) throws UnknownHostException, SocketException {
        this.iaddr = InetAddress.getByName(hostname);
        this.iport = port;
        this.dgSocket = new DatagramSocket();
    }

    public UDPClient(String hostname, int port, int timeout) throws UnknownHostException, SocketException {
        this.iaddr = InetAddress.getByName(hostname);
        this.iport = port;
        this.dgSocket = new DatagramSocket();
        this.dgSocket.setSoTimeout(timeout);
    }

    public void setBufSize(int newBufSize) {
        this.bufSize = newBufSize;
    }

    public InetAddress getInetAddress() {
        if (this.dgPacketIn != null) {
            return this.dgPacketIn.getAddress();
        }
        return null;
    }

    public void send(byte[] data) throws IOException {
        DatagramPacket dgPacketOut = new DatagramPacket(data, data.length, this.iaddr, this.iport);
        this.dgSocket.send(dgPacketOut);
    }

    public byte[] receive() throws IOException {
        byte[] ibuf = new byte[this.bufSize];
        this.dgPacketIn = new DatagramPacket(ibuf, ibuf.length);
        try {
            this.dgSocket.receive(this.dgPacketIn);
        }
        catch (SocketException e) {
            this.dgSocket.receive(this.dgPacketIn);
        }
        byte[] data = new byte[this.dgPacketIn.getLength()];
        System.arraycopy(this.dgPacketIn.getData(), 0, data, 0, this.dgPacketIn.getLength());
        return data;
    }

    public void close() {
        this.dgSocket.close();
    }
}

