/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.ccache;

import java.io.IOException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.LoginOptions;
import sun.security.mule.krb5.internal.ccache.Credentials;
import sun.security.mule.krb5.internal.ccache.FileCredentialsCache;

public abstract class CredentialsCache {
    static CredentialsCache singleton = null;
    static String cacheName;
    private static boolean DEBUG;

    public static CredentialsCache getInstance(PrincipalName principal) {
        return FileCredentialsCache.acquireInstance(principal, null);
    }

    public static CredentialsCache getInstance(String cache) {
        if (cache.length() >= 5 && cache.substring(0, 5).equalsIgnoreCase("FILE:")) {
            return FileCredentialsCache.acquireInstance(null, cache.substring(5));
        }
        return FileCredentialsCache.acquireInstance(null, cache);
    }

    public static CredentialsCache getInstance(PrincipalName principal, String cache) {
        if (cache != null && cache.length() >= 5 && cache.regionMatches(true, 0, "FILE:", 0, 5)) {
            return FileCredentialsCache.acquireInstance(principal, cache.substring(5));
        }
        return FileCredentialsCache.acquireInstance(principal, cache);
    }

    public static CredentialsCache getInstance() {
        return FileCredentialsCache.acquireInstance();
    }

    public static CredentialsCache create(PrincipalName principal, String name) {
        if (name == null) {
            throw new RuntimeException("cache name error");
        }
        if (name.length() >= 5 && name.regionMatches(true, 0, "FILE:", 0, 5)) {
            name = name.substring(5);
            return FileCredentialsCache.New(principal, name);
        }
        return FileCredentialsCache.New(principal, name);
    }

    public static CredentialsCache create(PrincipalName principal) {
        return FileCredentialsCache.New(principal);
    }

    public static String cacheName() {
        return cacheName;
    }

    public abstract PrincipalName getPrimaryPrincipal();

    public abstract void update(Credentials var1);

    public abstract void save() throws IOException, KrbException;

    public abstract Credentials[] getCredsList();

    public abstract Credentials getDefaultCreds();

    public abstract Credentials getCreds(PrincipalName var1, Realm var2);

    public abstract Credentials getCreds(LoginOptions var1, PrincipalName var2, Realm var3);

    static {
        DEBUG = Krb5.DEBUG;
    }
}

