/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.crypto.dk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Cipher;
import sun.misc.HexDumpEncoder;
import sun.security.mule.krb5.Confounder;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.internal.crypto.KeyUsage;

public abstract class DkCrypto {
    protected static final boolean debug = false;
    static final byte[] KERBEROS_CONSTANT = new byte[]{107, 101, 114, 98, 101, 114, 111, 115};

    protected abstract int getKeySeedLength();

    protected abstract byte[] randomToKey(byte[] var1);

    protected abstract Cipher getCipher(byte[] var1, byte[] var2, int var3) throws GeneralSecurityException;

    public abstract int getChecksumLength();

    protected abstract byte[] getHmac(byte[] var1, byte[] var2) throws GeneralSecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] baseKey, int usage, byte[] ivec, byte[] new_ivec, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        byte[] byArray;
        byte[] Ki;
        block7: {
            if (!KeyUsage.isValid(usage)) {
                throw new GeneralSecurityException("Invalid key usage number: " + usage);
            }
            byte[] Ke = null;
            Ki = null;
            try {
                byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                Ke = this.dk(baseKey, constant);
                Cipher encCipher = this.getCipher(Ke, ivec, 1);
                int blockSize = encCipher.getBlockSize();
                byte[] confounder = Confounder.bytes(blockSize);
                int plainSize = this.roundup(confounder.length + len, blockSize);
                byte[] toBeEncrypted = new byte[plainSize];
                System.arraycopy(confounder, 0, toBeEncrypted, 0, confounder.length);
                System.arraycopy(plaintext, start, toBeEncrypted, confounder.length, len);
                Arrays.fill(toBeEncrypted, confounder.length + len, plainSize, (byte)0);
                int cipherSize = encCipher.getOutputSize(plainSize);
                int ccSize = cipherSize + this.getChecksumLength();
                byte[] ciphertext = new byte[ccSize];
                encCipher.doFinal(toBeEncrypted, 0, plainSize, ciphertext, 0);
                if (new_ivec != null && new_ivec.length == blockSize) {
                    System.arraycopy(ciphertext, cipherSize - blockSize, new_ivec, 0, blockSize);
                }
                constant[4] = 85;
                Ki = this.dk(baseKey, constant);
                byte[] hmac = this.getHmac(Ki, toBeEncrypted);
                System.arraycopy(hmac, 0, ciphertext, cipherSize, this.getChecksumLength());
                byArray = ciphertext;
                if (Ke == null) break block7;
            }
            catch (Throwable throwable) {
                if (Ke != null) {
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    public byte[] encryptRaw(byte[] baseKey, int usage, byte[] ivec, byte[] plaintext, int start, int len) throws GeneralSecurityException, KrbCryptoException {
        Cipher encCipher = this.getCipher(baseKey, ivec, 1);
        int blockSize = encCipher.getBlockSize();
        if (len % blockSize != 0) {
            throw new GeneralSecurityException("length of data to be encrypted (" + len + ") is not a multiple of the blocksize (" + blockSize + ")");
        }
        int cipherSize = encCipher.getOutputSize(len);
        byte[] ciphertext = new byte[cipherSize];
        encCipher.doFinal(plaintext, 0, len, ciphertext, 0);
        return ciphertext;
    }

    public byte[] decryptRaw(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        Cipher decCipher = this.getCipher(baseKey, ivec, 2);
        int blockSize = decCipher.getBlockSize();
        if (len % blockSize != 0) {
            throw new GeneralSecurityException("length of data to be decrypted (" + len + ") is not a multiple of the blocksize (" + blockSize + ")");
        }
        byte[] decrypted = decCipher.doFinal(ciphertext, start, len);
        return decrypted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] baseKey, int usage, byte[] ivec, byte[] ciphertext, int start, int len) throws GeneralSecurityException {
        byte[] byArray;
        byte[] Ki;
        block10: {
            if (!KeyUsage.isValid(usage)) {
                throw new GeneralSecurityException("Invalid key usage number: " + usage);
            }
            byte[] Ke = null;
            Ki = null;
            try {
                byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -86};
                Ke = this.dk(baseKey, constant);
                Cipher decCipher = this.getCipher(Ke, ivec, 2);
                int blockSize = decCipher.getBlockSize();
                int cksumSize = this.getChecksumLength();
                int cipherSize = len - cksumSize;
                byte[] decrypted = decCipher.doFinal(ciphertext, start, cipherSize);
                constant[4] = 85;
                Ki = this.dk(baseKey, constant);
                byte[] calculatedHmac = this.getHmac(Ki, decrypted);
                boolean cksumFailed = false;
                if (calculatedHmac.length >= cksumSize) {
                    for (int i = 0; i < cksumSize; ++i) {
                        if (calculatedHmac[i] == ciphertext[cipherSize + i]) continue;
                        cksumFailed = true;
                        break;
                    }
                }
                if (cksumFailed) {
                    throw new GeneralSecurityException("Checksum failed");
                }
                if (ivec != null && ivec.length == blockSize) {
                    System.arraycopy(ciphertext, start + cipherSize - blockSize, ivec, 0, blockSize);
                }
                byte[] plaintext = new byte[decrypted.length - blockSize];
                System.arraycopy(decrypted, blockSize, plaintext, 0, plaintext.length);
                byArray = plaintext;
                if (Ke == null) break block10;
            }
            catch (Throwable throwable) {
                if (Ke != null) {
                    Arrays.fill(Ke, 0, Ke.length, (byte)0);
                }
                if (Ki != null) {
                    Arrays.fill(Ki, 0, Ki.length, (byte)0);
                }
                throw throwable;
            }
            Arrays.fill(Ke, 0, Ke.length, (byte)0);
        }
        if (Ki != null) {
            Arrays.fill(Ki, 0, Ki.length, (byte)0);
        }
        return byArray;
    }

    int roundup(int n, int blocksize) {
        return (n + blocksize - 1) / blocksize * blocksize;
    }

    public byte[] calculateChecksum(byte[] baseKey, int usage, byte[] input, int start, int len) throws GeneralSecurityException {
        if (!KeyUsage.isValid(usage)) {
            throw new GeneralSecurityException("Invalid key usage number: " + usage);
        }
        byte[] constant = new byte[]{(byte)(usage >> 24 & 0xFF), (byte)(usage >> 16 & 0xFF), (byte)(usage >> 8 & 0xFF), (byte)(usage & 0xFF), -103};
        byte[] Kc = this.dk(baseKey, constant);
        try {
            byte[] hmac = this.getHmac(Kc, input);
            if (hmac.length == this.getChecksumLength()) {
                byte[] byArray = hmac;
                return byArray;
            }
            if (hmac.length > this.getChecksumLength()) {
                byte[] buf = new byte[this.getChecksumLength()];
                System.arraycopy(hmac, 0, buf, 0, buf.length);
                byte[] byArray = buf;
                return byArray;
            }
            throw new GeneralSecurityException("checksum size too short: " + hmac.length + "; expecting : " + this.getChecksumLength());
        }
        finally {
            Arrays.fill(Kc, 0, Kc.length, (byte)0);
        }
    }

    byte[] dk(byte[] key, byte[] constant) throws GeneralSecurityException {
        return this.randomToKey(this.dr(key, constant));
    }

    private byte[] dr(byte[] key, byte[] constant) throws GeneralSecurityException {
        int len;
        Cipher encCipher = this.getCipher(key, null, 1);
        int blocksize = encCipher.getBlockSize();
        if (constant.length != blocksize) {
            constant = DkCrypto.nfold(constant, blocksize * 8);
        }
        byte[] toBeEncrypted = constant;
        int keybytes = this.getKeySeedLength() >> 3;
        byte[] rawkey = new byte[keybytes];
        boolean posn = false;
        for (int n = 0; n < keybytes; n += len) {
            byte[] cipherBlock = encCipher.doFinal(toBeEncrypted);
            len = keybytes - n <= cipherBlock.length ? keybytes - n : cipherBlock.length;
            System.arraycopy(cipherBlock, 0, rawkey, n, len);
            toBeEncrypted = cipherBlock;
        }
        return rawkey;
    }

    static byte[] nfold(byte[] in, int outbits) {
        int i;
        int inbits = in.length;
        int a = outbits >>= 3;
        int b = inbits;
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        int lcm = outbits * inbits / a;
        byte[] out = new byte[outbits];
        Arrays.fill(out, (byte)0);
        int thisbyte = 0;
        for (i = lcm - 1; i >= 0; --i) {
            int msbit = ((inbits << 3) - 1 + ((inbits << 3) + 13) * (i / inbits) + (inbits - i % inbits << 3)) % (inbits << 3);
            int bval = ((in[(inbits - 1 - (msbit >>> 3)) % inbits] & 0xFF) << 8 | in[(inbits - (msbit >>> 3)) % inbits] & 0xFF) >>> (msbit & 7) + 1 & 0xFF;
            thisbyte += bval;
            int oval = out[i % outbits] & 0xFF;
            out[i % outbits] = (byte)((thisbyte += oval) & 0xFF);
            thisbyte >>>= 8;
        }
        if (thisbyte != 0) {
            for (i = outbits - 1; i >= 0; --i) {
                out[i] = (byte)((thisbyte += out[i] & 0xFF) & 0xFF);
                thisbyte >>>= 8;
            }
        }
        return out;
    }

    static String bytesToString(byte[] digest) {
        StringBuffer digestString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            if ((digest[i] & 0xFF) < 16) {
                digestString.append("0" + Integer.toHexString(digest[i] & 0xFF));
                continue;
            }
            digestString.append(Integer.toHexString(digest[i] & 0xFF));
        }
        return digestString.toString();
    }

    private static byte[] binaryStringToBytes(String str) {
        char[] usageStr = str.toCharArray();
        byte[] usage = new byte[usageStr.length / 2];
        for (int i = 0; i < usage.length; ++i) {
            byte a = Byte.parseByte(new String(usageStr, i * 2, 1), 16);
            byte b = Byte.parseByte(new String(usageStr, i * 2 + 1, 1), 16);
            usage[i] = (byte)(a << 4 | b);
        }
        return usage;
    }

    static void traceOutput(String traceTag, byte[] output, int offset, int len) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(len);
            new HexDumpEncoder().encodeBuffer((InputStream)new ByteArrayInputStream(output, offset, len), (OutputStream)out);
            System.err.println(traceTag + ":" + out.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static byte[] charToUtf8(char[] chars) {
        Charset utf8 = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.wrap(chars);
        ByteBuffer bb = utf8.encode(cb);
        int len = bb.limit();
        byte[] answer = new byte[len];
        bb.get(answer, 0, len);
        return answer;
    }

    static byte[] charToUtf16(char[] chars) {
        Charset utf8 = Charset.forName("UTF-16LE");
        CharBuffer cb = CharBuffer.wrap(chars);
        ByteBuffer bb = utf8.encode(cb);
        int len = bb.limit();
        byte[] answer = new byte[len];
        bb.get(answer, 0, len);
        return answer;
    }
}

