/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.ktab;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import sun.security.mule.krb5.internal.ktab.KeyTabConstants;
import sun.security.mule.krb5.internal.ktab.KeyTabEntry;
import sun.security.mule.krb5.internal.util.KrbDataOutputStream;

public class KeyTabOutputStream
extends KrbDataOutputStream
implements KeyTabConstants {
    private KeyTabEntry entry;
    private int keyType;
    private byte[] keyValue;
    public int version;

    public KeyTabOutputStream(OutputStream os) {
        super(os);
    }

    public void writeVersion(int num) throws IOException {
        this.version = num;
        this.write16(num);
    }

    public void writeEntry(KeyTabEntry entry) throws IOException {
        this.write32(entry.entryLength());
        String[] serviceNames = entry.service.getNameStrings();
        int comp_num = serviceNames.length;
        if (this.version == 1281) {
            this.write16(comp_num + 1);
        } else {
            this.write16(comp_num);
        }
        byte[] realm = null;
        try {
            realm = entry.service.getRealmString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException exc) {
            // empty catch block
        }
        this.write16(realm.length);
        this.write(realm);
        for (int i = 0; i < comp_num; ++i) {
            try {
                this.write16(serviceNames[i].getBytes("8859_1").length);
                this.write(serviceNames[i].getBytes("8859_1"));
                continue;
            }
            catch (UnsupportedEncodingException exc) {
                // empty catch block
            }
        }
        this.write32(entry.service.getNameType());
        this.write32((int)(entry.timestamp.getTime() / 1000L));
        this.write8(entry.keyVersion % 256);
        this.write16(entry.keyType);
        this.write16(entry.keyblock.length);
        this.write(entry.keyblock);
    }
}

