/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.internal.rcache;

import java.util.LinkedList;
import java.util.ListIterator;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.rcache.AuthTime;
import sun.security.mule.krb5.internal.rcache.CacheTable;

public class ReplayCache
extends LinkedList<AuthTime> {
    private static final long serialVersionUID = 2997933194993803994L;
    private String principal;
    private CacheTable table;
    private int nap = 600000;
    private boolean DEBUG = Krb5.DEBUG;
    private Config kerberosConfig;

    public ReplayCache(String p, CacheTable ct, Config kerberosConfigs) {
        this.principal = p;
        this.table = ct;
        this.kerberosConfig = this.kerberosConfig;
    }

    public synchronized void put(AuthTime t, long currentTime) {
        block9: {
            AuthTime temp;
            block11: {
                block10: {
                    block8: {
                        if (this.size() != 0) break block8;
                        this.addFirst(t);
                        break block9;
                    }
                    temp = (AuthTime)this.getFirst();
                    if (temp.kerberosTime >= t.kerberosTime) break block10;
                    this.addFirst(t);
                    break block9;
                }
                if (temp.kerberosTime != t.kerberosTime) break block11;
                if (temp.cusec >= t.cusec) break block9;
                this.addFirst(t);
                break block9;
            }
            ListIterator it = this.listIterator(1);
            while (it.hasNext()) {
                temp = (AuthTime)it.next();
                if (temp.kerberosTime < t.kerberosTime) {
                    this.add(this.indexOf(temp), t);
                    break;
                }
                if (temp.kerberosTime != t.kerberosTime || temp.cusec >= t.cusec) continue;
                this.add(this.indexOf(temp), t);
                break;
            }
        }
        long timeLimit = currentTime - (long)KerberosTime.getDefaultSkew(this.kerberosConfig) * 1000L;
        ListIterator it = this.listIterator(0);
        AuthTime temp = null;
        int index = -1;
        while (it.hasNext()) {
            temp = (AuthTime)it.next();
            if (temp.kerberosTime >= timeLimit) continue;
            index = this.indexOf(temp);
            break;
        }
        if (index > -1) {
            do {
                this.removeLast();
            } while (this.size() > index);
        }
        if (this.DEBUG) {
            this.printList();
        }
        if (this.size() == 0) {
            this.table.remove(this.principal);
        }
        if (this.DEBUG) {
            this.printList();
        }
    }

    private void printList() {
        Object[] total = this.toArray();
        for (int i = 0; i < total.length; ++i) {
            System.out.println("object " + i + ": " + ((AuthTime)total[i]).kerberosTime + "/" + ((AuthTime)total[i]).cusec);
        }
    }
}

