package org.mule.tools.cxf.utils.binding;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.endpoint.Client;

/**
 * This class allows you to modify the service port a client. It's useful when
 * you have created your client based on a particular WSDL but the
 * implementations should hit different hosts.
 * 
 * @author damiansima
 * 
 */
public class ServicePortModificator {

    public static void modify(Client client, String serviceLocation) {
        ((BindingProvider) client).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, serviceLocation);
    }
}
