package org.mule.tools.cxf.utils.debug;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

/**
 * Provides static options to add debugging to the client proxy in CXF
 * 
 * @author gustavoalberola
 */
public class DebugUtils {

    /**
     * Add loggin interceptors to the CXF client.
     * <p>
     * This will make that before processing all the interceptors the SOAP
     * Envelope will be logged in console
     * 
     * @param client
     *            The client proxy to which the interceptors will be added
     */
    static public void registerDebugInterceptors(Client client) {
        if (client != null) {
            client.getEndpoint().getInInterceptors().add(0, new LoggingInInterceptor());
            client.getEndpoint().getOutInterceptors().add(0, new LoggingOutInterceptor());
        }
    }
}