package org.mule.tools.cxf.utils.policy;

import java.util.Collection;

import javax.xml.namespace.QName;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;

/**
 * It's the simpler implementation possible of a {@link AbstractSoapInterceptor}
 * 
 * 
 * @author damiansima
 * 
 */
public class CustomPolicyInterceptor extends AbstractSoapInterceptor {

    private QName qName;

    public CustomPolicyInterceptor(String nameSpaceURI, String localPart, String prefix) {
        this(new QName(nameSpaceURI, localPart, prefix));
    }

    public CustomPolicyInterceptor(QName qName) {
        super(Phase.PRE_PROTOCOL);
        this.qName = qName;
    }

    public void handleMessage(SoapMessage message) throws Fault {
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }

        Collection<AssertionInfo> ais = aim.get(qName);
        if (null == ais || ais.size() == 0) {
            return;
        }
        for (AssertionInfo ai : ais) {
            ai.setAsserted(true);
        }
    }
}