package org.mule.tools.cxf.utils.policy;

import java.util.Arrays;
import java.util.Collection;

import javax.xml.namespace.QName;

import org.apache.commons.lang.Validate;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;

/**
 * This is a customizable {@link PolicyInterceptorProvider} When created it will
 * register the {@link Interceptor} provided.
 * 
 * @author damiansima
 * 
 */
@SuppressWarnings("serial")
public class CustomPolicyProvider extends AbstractPolicyInterceptorProvider {

    /**
     * {@link CustomPolicyProvider} constructor.
     * 
     * This particular constructor creates and add a
     * {@link CustomPolicyInterceptor} with the same nameSpaceURI, localPart and
     * prefix.
     * 
     * @param nameSpaceURI
     * @param localPart
     * @param prefix
     */
    @SuppressWarnings("rawtypes")
    public CustomPolicyProvider(String nameSpaceURI, String localPart, String prefix) {
        this(new QName(nameSpaceURI, localPart, prefix), new CustomPolicyInterceptor(nameSpaceURI, localPart, prefix));
    }

    /**
     * {@link CustomPolicyProvider} constructor.
     * 
     * @param nameSpaceURI
     * @param localPart
     * @param prefix
     * @param customPolicyInterceptor
     */
    @SuppressWarnings("rawtypes")
    public CustomPolicyProvider(String nameSpaceURI, String localPart, String prefix,
            Interceptor customPolicyInterceptor) {
        this(new QName(nameSpaceURI, localPart, prefix), customPolicyInterceptor);
    }

    /**
     * {@link CustomPolicyProvider} constructor.
     * 
     * @param qName
     * @param customPolicyInterceptor
     */
    @SuppressWarnings("rawtypes")
    public CustomPolicyProvider(QName qName, Interceptor customPolicyInterceptor) {
        super((Collection) Arrays.asList(new QName[] { qName }));

        getInInterceptors().add(customPolicyInterceptor);
    }

}
