package org.mule.tools.cxf.utils.security;

import org.apache.cxf.endpoint.Client;

public interface Authenticator {

    /**
     * Set up authentication policy for a CXF service port with the user and
     * password provided.
     * 
     * @param servicePort
     * @param user
     * @param password
     */
    public Client setCredentials(Object servicePort, String user, String password);

    /**
     * Set up authentication policy for a CXF client with the user and password
     * provided.
     * 
     * @param client
     * @param user
     * @param password
     */
    public Client setCredentials(Client client, String user, String password);

}