package org.mule.tools.cxf.utils.security;

import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;

/**
 * It provides the security credentials set up for a CXF client.
 * 
 * It knows how to set up the HTTP Basic Authentication policy.
 * 
 * @author damiansima
 */
public class HttpBasicAuthenticator implements Authenticator {

    /* (non-Javadoc)
     * @see org.mule.tools.cxf.utils.security.Authenticator#setCredentials(java.lang.Object, java.lang.String, java.lang.String)
     */
    @Override
    public Client setCredentials(Object servicePort, String user, String password) {
        Client client = ClientProxy.getClient(servicePort);

        return setCredentials(client, user, password);

    }

    /* (non-Javadoc)
     * @see org.mule.tools.cxf.utils.security.Authenticator#setCredentials(org.apache.cxf.endpoint.Client, java.lang.String, java.lang.String)
     */
    @Override
    public Client setCredentials(Client client, String user, String password) {
        HTTPConduit http = (HTTPConduit) client.getConduit();

        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setUserName(user);
        authPolicy.setPassword(password);
        authPolicy.setAuthorizationType("Basic");

        http.setAuthorization(authPolicy);

        return client;
    }

}
