package org.mule.tools.cxf.utils.security;

import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

/**
 * It provides the security credentials set up for a CXF client.
 * 
 * It knows how to set up a CXF client to work with NTLM security .
 * 
 * @author damiansima
 */
public class NTLMAuthenticator implements Authenticator {
    /**
     * Setup NTLM auth parameters for a CXF client with the user and password
     * provided.
     * 
     * @param servicePort
     * @param user
     * @param password
     */
    @Override
    public Client setCredentials(Object servicePort, String user, String password) {
        Client client = ClientProxy.getClient(servicePort);

        return setCredentials(client, user, password);
    }

    /**
     * Set up NTLM auth parameters for a CXF client with the user and password
     * provided.
     * 
     * @param client
     * @param user
     * @param password
     */
    @Override
    public Client setCredentials(Client client, String user, String password) {
        HTTPConduit http = (HTTPConduit) client.getConduit();

        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(36000);
        httpClientPolicy.setAllowChunking(false);
        http.setClient(httpClientPolicy);

        AuthorizationPolicy authPolicy = new AuthorizationPolicy();
        authPolicy.setUserName(user);
        authPolicy.setPassword(password);

        http.setAuthorization(authPolicy);

        return client;

    }
}
