/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package org.mule.tools.cxf.utils.security;

import org.apache.ws.security.spnego.SpnegoClientAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

import sun.security.mule.jgss.GSSManagerImpl;
import sun.security.mule.jgss.GSSNameImpl;
import sun.security.mule.jgss.krb5.Krb5NameElement;
import sun.security.mule.jgss.spi.GSSNameSpi;
import sun.security.mule.krb5.Config;

public class XRMSpnegoClientAction implements SpnegoClientAction {

	private org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(XRMSpnegoClientAction.class);

	protected String serviceName;
	protected GSSContext secContext;
	protected boolean mutualAuth;
	private Config kerberosConfig;

	public XRMSpnegoClientAction(Config kerberosConfig) {
		this.kerberosConfig = kerberosConfig;
	}
	
	/**
	 * Whether to enable mutual authentication or not.
	 */
	public void setMutualAuth(boolean mutualAuthentication) {
		mutualAuth = mutualAuthentication;
	}

	/**
	 * The Service Name
	 */
	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}
	
	/**
	 * Get the GSSContext that was created after a service ticket was obtained
	 */
	public GSSContext getContext() {
		return secContext;
	}

	/**
	 * Obtain a service ticket
	 */
	public byte[] run() {
		
		log.debug("Starting negotiaton for Kerberos TGS");
		
		try {
			Oid oid = new Oid("1.3.6.1.5.5.2");
			GSSManagerImpl gssManager = new GSSManagerImpl(kerberosConfig);
			GSSNameSpi krb5NameElement = Krb5NameElement.getInstance(serviceName, null, kerberosConfig);			
			GSSName gssSerive = new GSSNameImpl(gssManager, krb5NameElement);
			
			secContext = gssManager.createContext(gssSerive, oid, null, GSSContext.DEFAULT_LIFETIME);
			
			secContext.requestMutualAuth(mutualAuth);
			secContext.requestCredDeleg(Boolean.FALSE);
			
			byte[] token = new byte[0];
			return secContext.initSecContext(token, 0, token.length);
		} catch (GSSException e) {
			log.error("Error in obtaining a Kerberos TGS", e);
		}

		return null;
	}
}
