/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

package sun.security.mule.jgss.spnego;

import org.ietf.jgss.*;
import java.security.Provider;
import sun.security.mule.jgss.GSSCredentialImpl;
import sun.security.mule.jgss.GSSUtil;
import sun.security.mule.jgss.ProviderList;
import sun.security.mule.jgss.spi.GSSCredentialSpi;
import sun.security.mule.jgss.spi.GSSNameSpi;

/**
 * This class is the cred element implementation for SPNEGO mech.
 * NOTE: The current implementation can only support one mechanism.
 * This should be changed once multi-mechanism support is needed.
 *
 * @author Valerie Peng
 * @since 1.6
 */
public class SpNegoCredElement implements GSSCredentialSpi {

    private GSSCredentialSpi cred = null;

    SpNegoCredElement(GSSCredentialSpi cred) throws GSSException {
        this.cred = cred;
    }

    Oid getInternalMech() {
        return cred.getMechanism();
    }

    // Used by GSSUtil.populateCredentials()
    public GSSCredentialSpi getInternalCred() {
        return cred;
    }

    public Provider getProvider() {
        return SpNegoMechFactory.PROVIDER;
    }

    public void dispose() throws GSSException {
        cred.dispose();
    }

    public GSSNameSpi getName() throws GSSException {
        return cred.getName();
    }

    public int getInitLifetime() throws GSSException {
        return cred.getInitLifetime();
    }

    public int getAcceptLifetime() throws GSSException {
        return cred.getAcceptLifetime();
    }

    public boolean isInitiatorCredential() throws GSSException {
        return cred.isInitiatorCredential();
    }

    public boolean isAcceptorCredential() throws GSSException {
        return cred.isAcceptorCredential();
    }

    public Oid getMechanism() {
        return GSSUtil.GSS_SPNEGO_MECH_OID;
    }
}
