/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/*
 * (C) Copyright IBM Corp. 1999 All Rights Reserved.
 * Copyright 1997 The Open Group Research Institute. All rights reserved.
 */

package sun.security.mule.krb5;

import java.io.IOException;

import sun.security.mule.krb5.internal.EncTGSRepPart;
import sun.security.mule.krb5.internal.KRBError;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.TGSRep;
import sun.security.mule.krb5.internal.TGSReq;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.crypto.KeyUsage;
import sun.security.util.DerValue;

/**
 * This class encapsulates a TGS-REP that is sent from the KDC to the
 * Kerberos client.
 */
public class KrbTgsRep extends KrbKdcRep {
	private TGSRep rep;
	private Credentials creds;
	private Ticket secondTicket;
	private static final boolean DEBUG = Krb5.DEBUG;

	KrbTgsRep(byte[] ibuf, KrbTgsReq tgsReq, Config kerberosConfig) throws KrbException, IOException {
		DerValue ref = new DerValue(ibuf);
		TGSReq req = tgsReq.getMessage();
		TGSRep rep = null;
		try {
			rep = new TGSRep(ref);
		} catch (Asn1Exception e) {
			rep = null;
			KRBError err = new KRBError(ref, kerberosConfig);
			String errStr = err.getErrorString();
			String eText = null; // pick up text sent by the server (if any)
			if (errStr != null && errStr.length() > 0) {
				if (errStr.charAt(errStr.length() - 1) == 0)
					eText = errStr.substring(0, errStr.length() - 1);
				else
					eText = errStr;
			}
			KrbException ke;
			if (eText == null) {
				// no text sent from server
				ke = new KrbException(err.getErrorCode());
			} else {
				// override default text with server text
				ke = new KrbException(err.getErrorCode(), eText);
			}
			ke.initCause(e);
			throw ke;
		}
		byte[] enc_tgs_rep_bytes = rep.encPart.decrypt(tgsReq.tgsReqKey, tgsReq.usedSubkey() ? KeyUsage.KU_ENC_TGS_REP_PART_SUBKEY
				: KeyUsage.KU_ENC_TGS_REP_PART_SESSKEY);

		byte[] enc_tgs_rep_part = rep.encPart.reset(enc_tgs_rep_bytes, true);
		ref = new DerValue(enc_tgs_rep_part);
		EncTGSRepPart enc_part = new EncTGSRepPart(ref, kerberosConfig);
		rep.ticket.sname.setRealm(rep.ticket.realm);
		rep.encKDCRepPart = enc_part;

		check(req, rep);

		creds = new Credentials(rep.ticket, req.reqBody.cname, rep.ticket.sname, enc_part.key, enc_part.flags, enc_part.authtime,
				enc_part.starttime, enc_part.endtime, enc_part.renewTill, enc_part.caddr);
		this.rep = rep;
		this.creds = creds;
		this.secondTicket = tgsReq.getSecondTicket();
	}

	/**
	 * Return the credentials that were contained in this KRB-TGS-REP.
	 */
	public Credentials getCreds() {
		return creds;
	}

	sun.security.mule.krb5.internal.ccache.Credentials setCredentials() {
		return new sun.security.mule.krb5.internal.ccache.Credentials(rep, secondTicket);
	}
}
