/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/*
 *  (C) Copyright IBM Corp. 1999 All Rights Reserved.
 *  Copyright 1997 The Open Group Research Institute.  All rights reserved.
 */

package sun.security.mule.krb5;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServiceName extends PrincipalName {

    public ServiceName(String name, int type, Config kerberosConfig) throws RealmException {
        super(name, type, kerberosConfig);

    }
    public ServiceName(String name, Config kerberosConfig) throws RealmException {
        this(name, PrincipalName.KRB_NT_UNKNOWN, kerberosConfig);
    }

    public ServiceName(String name, String realm, Config kerberosConfig) throws RealmException {
        this(name, PrincipalName.KRB_NT_UNKNOWN, kerberosConfig);
        setRealm(realm);
    }

    public ServiceName (String service, String instance, String realm)
        throws KrbException
    {
        super(service, instance, realm, PrincipalName.KRB_NT_SRV_INST);
    }

}
