/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/*
 * (C) Copyright IBM Corp. 1999 All Rights Reserved.
 * Copyright 1997 The Open Group Research Institute. All rights reserved.
 */

package sun.security.mule.krb5.internal;

import sun.security.mule.krb5.*;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.util.*;
import java.io.IOException;

public class EncTGSRepPart extends EncKDCRepPart {

	public EncTGSRepPart(EncryptionKey new_key, LastReq new_lastReq, int new_nonce, KerberosTime new_keyExpiration, TicketFlags new_flags,
			KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, Realm new_srealm,
			PrincipalName new_sname, HostAddresses new_caddr, Config kerberosConfig) {
		super(new_key, new_lastReq, new_nonce, new_keyExpiration, new_flags, new_authtime, new_starttime, new_endtime, new_renewTill,
				new_srealm, new_sname, new_caddr, Krb5.KRB_ENC_TGS_REP_PART, kerberosConfig);
	}

	public EncTGSRepPart(byte[] data, Config kerberosConfig) throws Asn1Exception, IOException, KrbException {
		super(kerberosConfig);
		init(new DerValue(data));
	}

	public EncTGSRepPart(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException, KrbException {
		super(kerberosConfig);
		init(encoding);
	}

	private void init(DerValue encoding) throws Asn1Exception, IOException, KrbException {
		init(encoding, Krb5.KRB_ENC_TGS_REP_PART);
	}

	public byte[] asn1Encode() throws Asn1Exception, IOException {
		return asn1Encode(Krb5.KRB_ENC_TGS_REP_PART);
	}

}
