/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/*
 * (C) Copyright IBM Corp. 1999 All Rights Reserved.
 * Copyright 1997 The Open Group Research Institute. All rights reserved.
 */

package sun.security.mule.krb5.internal;

import java.io.IOException;

import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class LastReqEntry {
	private int lrType;
	private KerberosTime lrValue;
	private Config kerberosConfig;

	private LastReqEntry(Config kerberosConfig) {
		this.kerberosConfig = kerberosConfig;
	}

	public LastReqEntry(int Type, KerberosTime time, Config kerberosConfig) {
		this.kerberosConfig = kerberosConfig;
		lrType = Type;
		lrValue = time;
		// XXX check the type and time.
	}

	/**
	 * Constructs a LastReqEntry object.
	 * 
	 * @param encoding
	 *            a Der-encoded data.
	 * @exception Asn1Exception
	 *                if an error occurs while decoding an ASN1 encoded data.
	 * @exception IOException
	 *                if an I/O error occurs while reading encoded data.
	 */
	public LastReqEntry(DerValue encoding, Config kerberosConfig) throws Asn1Exception, IOException {
		this.kerberosConfig = kerberosConfig;
		if (encoding.getTag() != DerValue.tag_Sequence) {
			throw new Asn1Exception(Krb5.ASN1_BAD_ID);
		}
		DerValue der;
		der = encoding.getData().getDerValue();
		if ((der.getTag() & 0x1F) == 0x00) {
			lrType = der.getData().getBigInteger().intValue();
		} else
			throw new Asn1Exception(Krb5.ASN1_BAD_ID);

		lrValue = KerberosTime.parse(encoding.getData(), (byte) 0x01, false, kerberosConfig);
		if (encoding.getData().available() > 0)
			throw new Asn1Exception(Krb5.ASN1_BAD_ID);
	}

	/**
	 * Encodes an LastReqEntry object.
	 * 
	 * @return the byte array of encoded LastReqEntry object.
	 * @exception Asn1Exception
	 *                if an error occurs while decoding an ASN1 encoded data.
	 * @exception IOException
	 *                if an I/O error occurs while reading encoded data.
	 */
	public byte[] asn1Encode() throws Asn1Exception, IOException {
		DerOutputStream bytes = new DerOutputStream();
		DerOutputStream temp = new DerOutputStream();
		temp.putInteger(lrType);
		bytes.write(DerValue.createTag(DerValue.TAG_CONTEXT, true, (byte) 0x00), temp);
		bytes.write(DerValue.createTag(DerValue.TAG_CONTEXT, true, (byte) 0x01), lrValue.asn1Encode());
		temp = new DerOutputStream();
		temp.write(DerValue.tag_Sequence, bytes);
		return temp.toByteArray();
	}

	public Object clone() {
		LastReqEntry newEntry = new LastReqEntry(kerberosConfig);
		newEntry.lrType = lrType;
		newEntry.lrValue = (KerberosTime) lrValue.clone();
		return newEntry;
	}
}
