/**
 * (c) 2003-2012 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master
 * Subscription Agreement (or other Terms of Service) separately entered
 * into between you and MuleSoft. If such an agreement is not in
 * place, you may not use the software.
 */

/*
 *  (C) Copyright IBM Corp. 1999 All Rights Reserved.
 *  Copyright 1997 The Open Group Research Institute.  All rights reserved.
 */

package sun.security.mule.krb5.internal.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * This class implements a buffered output stream. It provides methods to write a chunck of
 * bytes to underlying data stream.
 *
 * @author Yanni Zhang
 *
 */
public class KrbDataOutputStream extends BufferedOutputStream {
    public KrbDataOutputStream(OutputStream os) {
        super(os);
    }
    public void write32(int num) throws IOException {
        byte[] bytes = new byte[4];
        bytes[0] = (byte)((num & 0xff000000) >> 24 & 0xff);
        bytes[1] = (byte)((num & 0x00ff0000) >> 16 & 0xff);
        bytes[2] = (byte)((num & 0x0000ff00) >> 8 & 0xff);
        bytes[3] = (byte)(num & 0xff);
        write(bytes, 0, 4);
    }

    public void write16(int num) throws IOException {
        byte[] bytes = new byte[2];
        bytes[0] = (byte)((num & 0xff00) >> 8 & 0xff);
        bytes[1] = (byte)(num & 0xff);
        write(bytes, 0, 2);
    }

    public void write8(int num) throws IOException {
        write(num & 0xff);
    }
}
