/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.mule.jgss.GSSToken;
import sun.security.mule.jgss.krb5.CipherHelper;
import sun.security.mule.jgss.krb5.Krb5Context;
import sun.security.mule.jgss.krb5.Krb5Token;

abstract class MessageToken_v2
extends Krb5Token {
    private static final int TOKEN_ID_POS = 0;
    private static final int TOKEN_FLAG_POS = 2;
    private static final int TOKEN_EC_POS = 4;
    private static final int TOKEN_RRC_POS = 6;
    static final int TOKEN_HEADER_SIZE = 16;
    private int tokenId = 0;
    private int seqNumber;
    private int ec = 0;
    private int rrc = 0;
    private boolean confState = true;
    private boolean initiator = true;
    byte[] confounder = null;
    byte[] checksum = null;
    private int key_usage = 0;
    private byte[] seqNumberData = null;
    private MessageTokenHeader tokenHeader = null;
    CipherHelper cipherHelper = null;
    static final int KG_USAGE_ACCEPTOR_SEAL = 22;
    static final int KG_USAGE_ACCEPTOR_SIGN = 23;
    static final int KG_USAGE_INITIATOR_SEAL = 24;
    static final int KG_USAGE_INITIATOR_SIGN = 25;
    private static final int FLAG_SENDER_IS_ACCEPTOR = 1;
    private static final int FLAG_WRAP_CONFIDENTIAL = 2;
    private static final int FLAG_ACCEPTOR_SUBKEY = 4;
    private static final int FILLER = 255;

    MessageToken_v2(int tokenId, Krb5Context context, byte[] tokenBytes, int tokenOffset, int tokenLen, MessageProp prop) throws GSSException {
        this(tokenId, context, new ByteArrayInputStream(tokenBytes, tokenOffset, tokenLen), prop);
    }

    MessageToken_v2(int tokenId, Krb5Context context, InputStream is, MessageProp prop) throws GSSException {
        this.init(tokenId, context);
        try {
            if (!this.confState) {
                prop.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(is, prop, tokenId);
            if (tokenId == 1284) {
                this.key_usage = !this.initiator ? 24 : 22;
            } else if (tokenId == 1028) {
                this.key_usage = !this.initiator ? 25 : 23;
            }
            int tokenLen = is.available();
            byte[] data = new byte[tokenLen];
            MessageToken_v2.readFully(is, data);
            this.checksum = new byte[this.cipherHelper.getChecksumLength()];
            System.arraycopy(data, tokenLen - this.cipherHelper.getChecksumLength(), this.checksum, 0, this.cipherHelper.getChecksumLength());
            if (!prop.getPrivacy() && tokenId == 1284 && this.checksum.length != this.ec) {
                throw new GSSException(10, -1, MessageToken_v2.getTokenName(tokenId) + ":" + "EC incorrect!");
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, MessageToken_v2.getTokenName(tokenId) + ":" + e.getMessage());
        }
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final int getKeyUsage() {
        return this.key_usage;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public void genSignAndSeqNumber(MessageProp prop, byte[] data, int offset, int len) throws GSSException {
        int qop = prop.getQOP();
        if (qop != 0) {
            qop = 0;
            prop.setQOP(qop);
        }
        if (!this.confState) {
            prop.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, prop.getPrivacy(), true);
        if (this.tokenId == 1284) {
            this.key_usage = this.initiator ? 24 : 22;
        } else if (this.tokenId == 1028) {
            int n = this.key_usage = this.initiator ? 25 : 23;
        }
        if (this.tokenId == 1028 || !prop.getPrivacy() && this.tokenId == 1284) {
            this.checksum = this.getChecksum(data, offset, len);
        }
        if (!prop.getPrivacy() && this.tokenId == 1284) {
            byte[] tok_header = this.tokenHeader.getBytes();
            tok_header[4] = (byte)(this.checksum.length >>> 8);
            tok_header[5] = (byte)this.checksum.length;
        }
    }

    public final boolean verifySign(byte[] data, int offset, int len) throws GSSException {
        byte[] myChecksum = this.getChecksum(data, offset, len);
        return MessageDigest.isEqual(this.checksum, myChecksum);
    }

    public boolean rotate_left(byte[] in_bytes, int tokenOffset, byte[] out_bytes, int bufsize) {
        int offset = 0;
        if (this.rrc > 0) {
            if (bufsize == 0) {
                return false;
            }
            this.rrc %= bufsize - 16;
            if (this.rrc == 0) {
                return false;
            }
            if (tokenOffset > 0) {
                offset += tokenOffset;
            }
            System.arraycopy(in_bytes, offset, out_bytes, 0, 16);
            System.arraycopy(in_bytes, (offset += 16) + this.rrc, out_bytes, 16, bufsize - 16 - this.rrc);
            System.arraycopy(in_bytes, offset, out_bytes, bufsize - 16 - this.rrc, this.rrc);
            return true;
        }
        return false;
    }

    public final int getSequenceNumber() {
        return MessageToken_v2.readBigEndian(this.seqNumberData, 0, 4);
    }

    byte[] getChecksum(byte[] data, int offset, int len) throws GSSException {
        byte[] tokenHeaderBytes = this.tokenHeader.getBytes();
        int conf_flag = tokenHeaderBytes[2] & 2;
        if (conf_flag == 0 && this.tokenId == 1284) {
            tokenHeaderBytes[4] = 0;
            tokenHeaderBytes[5] = 0;
        }
        return this.cipherHelper.calculateChecksum(tokenHeaderBytes, data, offset, len, this.key_usage);
    }

    MessageToken_v2(int tokenId, Krb5Context context) throws GSSException {
        this.init(tokenId, context);
        this.seqNumber = context.incrementMySequenceNumber();
    }

    private void init(int tokenId, Krb5Context context) throws GSSException {
        this.tokenId = tokenId;
        this.confState = context.getConfState();
        this.initiator = context.isInitiator();
        this.cipherHelper = context.getCipherHelper(null);
        this.tokenId = tokenId;
    }

    public void encode(OutputStream os) throws IOException, GSSException {
        this.tokenHeader.encode(os);
        if (this.tokenId == 1028) {
            os.write(this.checksum);
        }
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize();
    }

    protected final int getTokenSize() throws GSSException {
        return 16 + this.cipherHelper.getChecksumLength();
    }

    protected static final int getTokenSize(CipherHelper ch) throws GSSException {
        return 16 + ch.getChecksumLength();
    }

    protected final byte[] getTokenHeader() {
        return this.tokenHeader.getBytes();
    }

    static /* synthetic */ byte[] access$102(MessageToken_v2 x0, byte[] x1) {
        x0.seqNumberData = x1;
        return x1;
    }

    class MessageTokenHeader {
        private int tokenId;
        private byte[] bytes = new byte[16];

        public MessageTokenHeader(int tokenId, boolean conf, boolean have_acceptor_subkey) throws GSSException {
            this.tokenId = tokenId;
            this.bytes[0] = (byte)(tokenId >>> 8);
            this.bytes[1] = (byte)tokenId;
            int flags = 0;
            flags = (MessageToken_v2.this.initiator ? 0 : 1) | (conf && tokenId != 1028 ? 2 : 0) | (have_acceptor_subkey ? 4 : 0);
            this.bytes[2] = (byte)flags;
            this.bytes[3] = -1;
            if (tokenId == 1284) {
                this.bytes[4] = 0;
                this.bytes[5] = 0;
                this.bytes[6] = 0;
                this.bytes[7] = 0;
            } else if (tokenId == 1028) {
                for (int i = 4; i < 8; ++i) {
                    this.bytes[i] = -1;
                }
            }
            MessageToken_v2.access$102(MessageToken_v2.this, new byte[8]);
            GSSToken.writeBigEndian(MessageToken_v2.this.seqNumber, MessageToken_v2.this.seqNumberData, 4);
            System.arraycopy(MessageToken_v2.this.seqNumberData, 0, this.bytes, 8, 8);
        }

        public MessageTokenHeader(InputStream is, MessageProp prop, int tokId) throws IOException, GSSException {
            GSSToken.readFully(is, this.bytes, 0, 16);
            this.tokenId = GSSToken.readInt(this.bytes, 0);
            int acceptor_flag = MessageToken_v2.this.initiator ? 1 : 0;
            int flag = this.bytes[2] & 1;
            if (flag != acceptor_flag) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Acceptor Flag Missing!");
            }
            int conf_flag = this.bytes[2] & 2;
            if (conf_flag == 2 && this.tokenId == 1284) {
                prop.setPrivacy(true);
            } else {
                prop.setPrivacy(false);
            }
            if (this.tokenId != tokId) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token ID!");
            }
            if ((this.bytes[3] & 0xFF) != 255) {
                throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
            }
            if (this.tokenId == 1028) {
                for (int i = 4; i < 8; ++i) {
                    if ((this.bytes[i] & 0xFF) == 255) continue;
                    throw new GSSException(10, -1, Krb5Token.getTokenName(this.tokenId) + ":" + "Defective Token Filler!");
                }
            }
            MessageToken_v2.this.ec = GSSToken.readBigEndian(this.bytes, 4, 2);
            MessageToken_v2.this.rrc = GSSToken.readBigEndian(this.bytes, 6, 2);
            prop.setQOP(0);
            MessageToken_v2.access$102(MessageToken_v2.this, new byte[8]);
            System.arraycopy(this.bytes, 8, MessageToken_v2.this.seqNumberData, 0, 8);
        }

        public final void encode(OutputStream os) throws IOException {
            os.write(this.bytes);
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }
    }
}

