/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.wrapper;

import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.mule.jgss.GSSUtil;
import sun.security.mule.jgss.spi.GSSCredentialSpi;
import sun.security.mule.jgss.wrapper.GSSLibStub;
import sun.security.mule.jgss.wrapper.GSSNameElement;
import sun.security.mule.jgss.wrapper.Krb5Util;
import sun.security.mule.jgss.wrapper.SunNativeProvider;

public class GSSCredElement
implements GSSCredentialSpi {
    private int usage;
    long pCred;
    private GSSNameElement name = null;
    private GSSLibStub cStub;

    void doServicePermCheck() throws GSSException {
        if (GSSUtil.isKerberosMech(this.cStub.getMech()) && System.getSecurityManager() != null) {
            if (this.isInitiatorCredential()) {
                String tgsName = Krb5Util.getTGSName(this.name);
                Krb5Util.checkServicePermission(tgsName, "initiate");
            }
            if (this.isAcceptorCredential() && this.name != GSSNameElement.DEF_ACCEPTOR) {
                String krbName = this.name.getKrbName();
                Krb5Util.checkServicePermission(krbName, "accept");
            }
        }
    }

    GSSCredElement(long pCredentials, GSSNameElement srcName, Oid mech) throws GSSException {
        this.pCred = pCredentials;
        this.cStub = GSSLibStub.getInstance(mech);
        this.usage = 1;
        this.name = srcName;
    }

    GSSCredElement(GSSNameElement name, int lifetime, int usage, GSSLibStub stub) throws GSSException {
        this.cStub = stub;
        this.usage = usage;
        if (name != null) {
            this.name = name;
            this.doServicePermCheck();
            this.pCred = this.cStub.acquireCred(this.name.pName, lifetime, usage);
        } else {
            this.pCred = this.cStub.acquireCred(0L, lifetime, usage);
            this.name = new GSSNameElement(this.cStub.getCredName(this.pCred), this.cStub);
            this.doServicePermCheck();
        }
    }

    @Override
    public Provider getProvider() {
        return SunNativeProvider.INSTANCE;
    }

    @Override
    public void dispose() throws GSSException {
        this.name = null;
        if (this.pCred != 0L) {
            this.pCred = this.cStub.releaseCred(this.pCred);
        }
    }

    @Override
    public GSSNameElement getName() throws GSSException {
        return this.name == GSSNameElement.DEF_ACCEPTOR ? null : this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        if (this.isInitiatorCredential()) {
            return this.cStub.getCredTime(this.pCred);
        }
        return 0;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        if (this.isAcceptorCredential()) {
            return this.cStub.getCredTime(this.pCred);
        }
        return 0;
    }

    @Override
    public boolean isInitiatorCredential() {
        return this.usage != 2;
    }

    @Override
    public boolean isAcceptorCredential() {
        return this.usage != 1;
    }

    @Override
    public Oid getMechanism() {
        return this.cStub.getMech();
    }

    public String toString() {
        return "N/A";
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

