/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.wrapper;

import java.util.Hashtable;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import sun.security.mule.jgss.wrapper.NativeGSSContext;
import sun.security.mule.jgss.wrapper.SunNativeProvider;

class GSSLibStub {
    private Oid mech;
    private long pMech;
    private static Hashtable<Oid, GSSLibStub> table = new Hashtable(5);

    static native boolean init(String var0);

    private static native long getMechPtr(byte[] var0);

    static native Oid[] indicateMechs();

    native Oid[] inquireNamesForMech() throws GSSException;

    native void releaseName(long var1);

    native long importName(byte[] var1, Oid var2);

    native boolean compareName(long var1, long var3);

    native long canonicalizeName(long var1);

    native byte[] exportName(long var1) throws GSSException;

    native Object[] displayName(long var1) throws GSSException;

    native long acquireCred(long var1, int var3, int var4) throws GSSException;

    native long releaseCred(long var1);

    native long getCredName(long var1);

    native int getCredTime(long var1);

    native int getCredUsage(long var1);

    native NativeGSSContext importContext(byte[] var1);

    native byte[] initContext(long var1, long var3, ChannelBinding var5, byte[] var6, NativeGSSContext var7);

    native byte[] acceptContext(long var1, ChannelBinding var3, byte[] var4, NativeGSSContext var5);

    native long[] inquireContext(long var1);

    native Oid getContextMech(long var1);

    native long getContextName(long var1, boolean var3);

    native int getContextTime(long var1);

    native long deleteContext(long var1);

    native int wrapSizeLimit(long var1, int var3, int var4, int var5);

    native byte[] exportContext(long var1);

    native byte[] getMic(long var1, int var3, byte[] var4);

    native void verifyMic(long var1, byte[] var3, byte[] var4, MessageProp var5);

    native byte[] wrap(long var1, byte[] var3, MessageProp var4);

    native byte[] unwrap(long var1, byte[] var3, MessageProp var4);

    static GSSLibStub getInstance(Oid mech) throws GSSException {
        GSSLibStub s = table.get(mech);
        if (s == null) {
            s = new GSSLibStub(mech);
            table.put(mech, s);
        }
        return s;
    }

    private GSSLibStub(Oid mech) throws GSSException {
        SunNativeProvider.debug("Created GSSLibStub for mech " + mech);
        this.mech = mech;
        this.pMech = GSSLibStub.getMechPtr(mech.getDER());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GSSLibStub)) {
            return false;
        }
        return this.mech.equals(((GSSLibStub)obj).getMech());
    }

    public int hashCode() {
        return this.mech.hashCode();
    }

    Oid getMech() {
        return this.mech;
    }
}

