/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.jgss.wrapper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.util.HashMap;
import org.ietf.jgss.Oid;
import sun.security.action.PutAllAction;
import sun.security.mule.jgss.wrapper.GSSLibStub;

public final class SunNativeProvider
extends Provider {
    private static final long serialVersionUID = -238911724858694204L;
    private static final String NAME = "SunNativeGSS";
    private static final String INFO = "Sun Native GSS provider";
    private static final String MF_CLASS = "sun.security.mule.jgss.wrapper.NativeGSSFactory";
    private static final String LIB_PROP = "sun.security.mule.jgss.lib";
    private static final String DEBUG_PROP = "sun.security.nativegss.debug";
    private static HashMap MECH_MAP;
    static final Provider INSTANCE;
    static boolean DEBUG;

    static void debug(String message) {
        if (DEBUG) {
            if (message == null) {
                throw new NullPointerException();
            }
            System.out.println("SunNativeGSS: " + message);
        }
    }

    public SunNativeProvider() {
        super(NAME, 1.0, INFO);
        if (MECH_MAP != null) {
            AccessController.doPrivileged(new PutAllAction(this, MECH_MAP));
        }
    }

    static {
        INSTANCE = new SunNativeProvider();
        MECH_MAP = AccessController.doPrivileged(new PrivilegedAction<HashMap>(){

            @Override
            public HashMap run() {
                DEBUG = Boolean.parseBoolean(System.getProperty(SunNativeProvider.DEBUG_PROP));
                try {
                    System.loadLibrary("j2gss");
                }
                catch (Error err) {
                    SunNativeProvider.debug("No j2gss library found!");
                    if (DEBUG) {
                        err.printStackTrace();
                    }
                    return null;
                }
                String gssLib = System.getProperty(SunNativeProvider.LIB_PROP);
                if (gssLib == null || gssLib.trim().equals("")) {
                    String osname = System.getProperty("os.name");
                    if (osname.startsWith("SunOS")) {
                        gssLib = "libgss.so";
                    } else if (osname.startsWith("Linux")) {
                        gssLib = "libgssapi.so";
                    }
                }
                if (GSSLibStub.init(gssLib)) {
                    SunNativeProvider.debug("Loaded GSS library: " + gssLib);
                    Oid[] mechs = GSSLibStub.indicateMechs();
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (int i = 0; i < mechs.length; ++i) {
                        SunNativeProvider.debug("Native MF for " + mechs[i]);
                        map.put("GssApiMechanism." + mechs[i], SunNativeProvider.MF_CLASS);
                    }
                    return map;
                }
                return null;
            }
        });
    }
}

