/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.internal.KdcErrException;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.crypto.CksumType;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Checksum {
    private int cksumType;
    private byte[] checksum;
    public static final int CKSUMTYPE_NULL = 0;
    public static final int CKSUMTYPE_CRC32 = 1;
    public static final int CKSUMTYPE_RSA_MD4 = 2;
    public static final int CKSUMTYPE_RSA_MD4_DES = 3;
    public static final int CKSUMTYPE_DES_MAC = 4;
    public static final int CKSUMTYPE_DES_MAC_K = 5;
    public static final int CKSUMTYPE_RSA_MD4_DES_K = 6;
    public static final int CKSUMTYPE_RSA_MD5 = 7;
    public static final int CKSUMTYPE_RSA_MD5_DES = 8;
    public static final int CKSUMTYPE_HMAC_SHA1_DES3_KD = 12;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES128 = 15;
    public static final int CKSUMTYPE_HMAC_SHA1_96_AES256 = 16;
    public static final int CKSUMTYPE_HMAC_MD5_ARCFOUR = -138;
    public static final int CKSUMTYPE_USE_DEFAULT = -999;
    private int CKSUMTYPE_DEFAULT;
    private int SAFECKSUMTYPE_DEFAULT;
    private Config kerberosConfig;
    private boolean inited = false;
    private static boolean DEBUG = Krb5.DEBUG;

    private synchronized void init() {
        if (!this.inited) {
            this.inited = true;
            String temp = null;
            temp = this.kerberosConfig.getDefault("default_checksum", "libdefaults");
            this.CKSUMTYPE_DEFAULT = temp != null ? this.kerberosConfig.getType(temp) : 7;
            try {
                temp = this.kerberosConfig.getDefault("safe_checksum_type", "libdefaults");
                this.SAFECKSUMTYPE_DEFAULT = temp != null ? this.kerberosConfig.getType(temp) : 8;
            }
            catch (Exception exc) {
                if (DEBUG) {
                    System.out.println("Exception in getting safe default checksum value from the configuration Setting  safe default checksum to be RSA-MD5");
                    exc.printStackTrace();
                }
                this.SAFECKSUMTYPE_DEFAULT = 8;
            }
        }
    }

    public static int getChecksumdefault(Config kerberosConfig) {
        String temp = kerberosConfig.getDefault("default_checksum", "libdefaults");
        if (temp != null) {
            return kerberosConfig.getType(temp);
        }
        return 7;
    }

    public Checksum(byte[] data, int new_cksumType, Config kerberosConfig) {
        this.kerberosConfig = kerberosConfig;
        this.cksumType = new_cksumType == -999 ? this.CKSUMTYPE_DEFAULT : new_cksumType;
        this.checksum = data;
        this.init();
    }

    public Checksum(int new_cksumType, byte[] data, Config kerberosConfig) throws KdcErrException, KrbCryptoException {
        this.kerberosConfig = kerberosConfig;
        this.init();
        this.cksumType = new_cksumType == -999 ? this.CKSUMTYPE_DEFAULT : new_cksumType;
        CksumType cksumEngine = CksumType.getInstance(this.cksumType);
        if (cksumEngine.isSafe()) {
            throw new KdcErrException(50);
        }
        this.checksum = cksumEngine.calculateChecksum(data, data.length);
    }

    public Checksum(int new_cksumType, byte[] data, EncryptionKey key, int usage, Config kerberosConfig) throws KdcErrException, KrbApErrException, KrbCryptoException {
        this.kerberosConfig = kerberosConfig;
        this.init();
        this.cksumType = new_cksumType == -999 ? this.CKSUMTYPE_DEFAULT : new_cksumType;
        CksumType cksumEngine = CksumType.getInstance(this.cksumType);
        if (!cksumEngine.isSafe()) {
            throw new KrbApErrException(50);
        }
        this.checksum = cksumEngine.calculateKeyedChecksum(data, data.length, key.getBytes(), usage);
    }

    public boolean verifyKeyedChecksum(byte[] data, EncryptionKey key, int usage) throws KdcErrException, KrbApErrException, KrbCryptoException {
        CksumType cksumEngine = CksumType.getInstance(this.cksumType);
        if (!cksumEngine.isSafe()) {
            throw new KrbApErrException(50);
        }
        return cksumEngine.verifyKeyedChecksum(data, data.length, key.getBytes(), this.checksum, usage);
    }

    boolean isEqual(Checksum cksum) throws KdcErrException {
        if (this.cksumType != cksum.cksumType) {
            return false;
        }
        CksumType cksumEngine = CksumType.getInstance(this.cksumType);
        return CksumType.isChecksumEqual(this.checksum, cksum.checksum);
    }

    private Checksum(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.cksumType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.checksum = der.getData().getOctetString();
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.cksumType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.checksum);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static Checksum parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Checksum(subDer);
    }

    public final byte[] getBytes() {
        return this.checksum;
    }

    public final int getType() {
        return this.cksumType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Checksum)) {
            return false;
        }
        try {
            return this.isEqual((Checksum)obj);
        }
        catch (KdcErrException kee) {
            return false;
        }
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.cksumType;
        if (this.checksum != null) {
            result = 37 * result + Arrays.hashCode(this.checksum);
        }
        return result;
    }
}

