/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.security.action.GetPropertyAction;
import sun.security.mule.jgss.GSSContextImpl;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.internal.crypto.EType;

public class Config {
    static final Log logger = LogFactory.getLog(Config.class);
    private static Config singleton = null;
    private Hashtable<String, Object> stanzaTable;
    private Map<String, Subject> subjects = new HashMap<String, Subject>();
    private GSSContextImpl kerberosContext;
    private static final int BASE16_0 = 1;
    private static final int BASE16_1 = 16;
    private static final int BASE16_2 = 256;
    private static final int BASE16_3 = 4096;
    private String defaultRealm;

    public GSSContextImpl getKerberosContext() {
        return this.kerberosContext;
    }

    public void setKerberosContext(GSSContextImpl kerberosContext) {
        this.kerberosContext = kerberosContext;
    }

    public void storeSubject(String principalName, Subject subject) {
        if (!StringUtils.isEmpty((String)principalName) && subject != null) {
            this.subjects.put(principalName, subject);
        }
    }

    public Subject retrieveSubject(String principalName) {
        if (!StringUtils.isEmpty((String)principalName)) {
            return this.subjects.get(principalName);
        }
        return null;
    }

    public Subject retrieveFirst() {
        if (this.subjects.size() > 0) {
            for (String key : this.subjects.keySet()) {
                if (this.subjects.get(key) == null) continue;
                return this.subjects.get(key);
            }
        }
        return null;
    }

    private static native String getWindowsDirectory();

    public static synchronized void refresh() throws KrbException {
    }

    public Config() throws KrbException {
        try {
            Vector<String> configFile = this.loadConfigFile();
            this.stanzaTable = this.parseStanzaTable(configFile);
        }
        catch (IOException ioe) {
            KrbException ke = new KrbException("Could not load configuration file " + ioe.getMessage());
            ke.initCause(ioe);
            throw ke;
        }
    }

    public Config(Vector<String> configFile) throws KrbException {
        try {
            this.stanzaTable = this.parseStanzaTable(configFile);
        }
        catch (KrbException e) {
            KrbException ke = new KrbException("Could not load configuration file " + e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public Config(String realm, String kdcLocation) throws KrbException {
        try {
            this.stanzaTable = this.parseStanzaTable(Config.loadDefaultConfigFile(realm, kdcLocation));
        }
        catch (KrbException e) {
            KrbException ke = new KrbException("Could not load configuration file " + e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public static Vector<String> loadDefaultConfigFile(String realm, String kdcLocation) {
        Vector<String> v = new Vector<String>();
        v.add("[libdefaults]");
        v.add(String.format("default_realm = %s", realm));
        v.add("default_tkt_enctypes = rc4-hmac aes128-cts des3-cbc-sha1 des-cbc-md5 des-cbc-crc");
        v.add("default_tgs_enctypes = rc4-hmac aes128-cts des3-cbc-sha1 des-cbc-md5 des-cbc-crc");
        v.add("permitted_enctypes = rc4-hmac aes128-cts des3-cbc-sha1 des-cbc-md5 des-cbc-crc");
        v.add("[realms]");
        v.add(String.format("%s = {", realm));
        v.add(String.format("kdc = %s", kdcLocation));
        v.add("}");
        v.add("[domain_realm]");
        v.add(String.format(".%s = %s", realm.toLowerCase(), realm));
        v.add(String.format("%s = %s", realm.toLowerCase(), realm));
        return v;
    }

    public int getDefaultIntValue(String name) {
        String result = null;
        int value = Integer.MIN_VALUE;
        result = this.getDefault(name);
        if (result != null) {
            try {
                value = this.parseIntValue(result);
            }
            catch (NumberFormatException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exception in getting value of " + name + " " + e.getMessage()));
                    logger.debug((Object)("Setting " + name + " to minimum value"));
                }
                value = Integer.MIN_VALUE;
            }
        }
        return value;
    }

    public int getDefaultIntValue(String name, String section) {
        String result = null;
        int value = Integer.MIN_VALUE;
        result = this.getDefault(name, section);
        if (result != null) {
            try {
                value = this.parseIntValue(result);
            }
            catch (NumberFormatException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Exception in getting value of " + name + " in section " + section + " " + e.getMessage()));
                    logger.debug((Object)("Setting " + name + " to minimum value"));
                }
                value = Integer.MIN_VALUE;
            }
        }
        return value;
    }

    public String getDefault(String name) {
        if (this.stanzaTable == null) {
            return null;
        }
        return this.getDefault(name, this.stanzaTable);
    }

    private String getDefault(String k, Hashtable t) {
        String result = null;
        if (this.stanzaTable != null) {
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object ob = t.get(key);
                if (ob instanceof Hashtable) {
                    result = this.getDefault(k, (Hashtable)ob);
                    if (result == null) continue;
                    return result;
                }
                if (!key.equalsIgnoreCase(k)) continue;
                if (ob instanceof String) {
                    return (String)t.get(key);
                }
                if (!(ob instanceof Vector)) continue;
                result = "";
                int length = ((Vector)ob).size();
                for (int i = 0; i < length; ++i) {
                    result = i == length - 1 ? result + (String)((Vector)ob).elementAt(i) : result + (String)((Vector)ob).elementAt(i) + " ";
                }
                return result;
            }
        }
        return result;
    }

    public String getDefault(String name, String section) {
        String result = null;
        if (name.equalsIgnoreCase("kdc") && !section.equalsIgnoreCase("libdefaults") && AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc")) != null) {
            result = this.getDefault("kdc", "libdefaults");
            return result;
        }
        if (this.stanzaTable != null) {
            Enumeration<String> e = this.stanzaTable.keys();
            while (e.hasMoreElements()) {
                Hashtable temp;
                Object ob;
                String stanzaName = e.nextElement();
                Hashtable subTable = (Hashtable)this.stanzaTable.get(stanzaName);
                if (stanzaName.equalsIgnoreCase(section)) {
                    if (!subTable.containsKey(name)) continue;
                    return (String)subTable.get(name);
                }
                if (!subTable.containsKey(section) || !((ob = subTable.get(section)) instanceof Hashtable) || !(temp = (Hashtable)ob).containsKey(name)) continue;
                Object object = temp.get(name);
                if (object instanceof Vector) {
                    result = "";
                    int length = ((Vector)object).size();
                    for (int i = 0; i < length; ++i) {
                        result = i == length - 1 ? result + (String)((Vector)object).elementAt(i) : result + (String)((Vector)object).elementAt(i) + " ";
                    }
                    continue;
                }
                result = (String)object;
            }
        }
        return result;
    }

    public boolean getDefaultBooleanValue(String name) {
        String val = null;
        val = this.stanzaTable == null ? null : this.getDefault(name, this.stanzaTable);
        return val != null && val.equalsIgnoreCase("true");
    }

    public boolean getDefaultBooleanValue(String name, String section) {
        String val = this.getDefault(name, section);
        return val != null && val.equalsIgnoreCase("true");
    }

    private int parseIntValue(String input) throws NumberFormatException {
        int value = 0;
        if (input.startsWith("+")) {
            String temp = input.substring(1);
            return Integer.parseInt(temp);
        }
        if (input.startsWith("0x")) {
            String temp = input.substring(2);
            char[] chars = temp.toCharArray();
            if (chars.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i = 0; i < chars.length; ++i) {
                int index = chars.length - i - 1;
                switch (chars[i]) {
                    case '0': {
                        value += 0;
                        continue block18;
                    }
                    case '1': {
                        value += 1 * this.getBase(index);
                        continue block18;
                    }
                    case '2': {
                        value += 2 * this.getBase(index);
                        continue block18;
                    }
                    case '3': {
                        value += 3 * this.getBase(index);
                        continue block18;
                    }
                    case '4': {
                        value += 4 * this.getBase(index);
                        continue block18;
                    }
                    case '5': {
                        value += 5 * this.getBase(index);
                        continue block18;
                    }
                    case '6': {
                        value += 6 * this.getBase(index);
                        continue block18;
                    }
                    case '7': {
                        value += 7 * this.getBase(index);
                        continue block18;
                    }
                    case '8': {
                        value += 8 * this.getBase(index);
                        continue block18;
                    }
                    case '9': {
                        value += 9 * this.getBase(index);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        value += 10 * this.getBase(index);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        value += 11 * this.getBase(index);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        value += 12 * this.getBase(index);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        value += 13 * this.getBase(index);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        value += 14 * this.getBase(index);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        value += 15 * this.getBase(index);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (value < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            value = Integer.parseInt(input);
        }
        return value;
    }

    private int getBase(int i) {
        int result = 16;
        switch (i) {
            case 0: {
                result = 1;
                break;
            }
            case 1: {
                result = 16;
                break;
            }
            case 2: {
                result = 256;
                break;
            }
            case 3: {
                result = 4096;
                break;
            }
            default: {
                for (int j = 1; j < i; ++j) {
                    result *= 16;
                }
            }
        }
        return result;
    }

    private String find(String key1, String key2) {
        String result;
        if (this.stanzaTable != null && (result = (String)((Hashtable)this.stanzaTable.get(key1)).get(key2)) != null) {
            return result;
        }
        return "";
    }

    private Vector<String> loadConfigFile() throws IOException {
        try {
            final String fileName = this.getFileName();
            if (!fileName.equals("")) {
                String Line;
                BufferedReader br = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(fileName);
                    }
                })));
                Vector<String> v = new Vector<String>();
                String previous = null;
                while ((Line = br.readLine()) != null) {
                    if (Line.startsWith("#") || Line.trim().isEmpty()) continue;
                    String current = Line.trim();
                    if (current.equals("{")) {
                        if (previous == null) {
                            throw new IOException("Config file should not start with \"{\"");
                        }
                        previous = previous + " " + current;
                        continue;
                    }
                    if (previous != null) {
                        v.addElement(previous);
                    }
                    previous = current;
                }
                if (previous != null) {
                    v.addElement(previous);
                }
                br.close();
                return v;
            }
            return null;
        }
        catch (PrivilegedActionException pe) {
            throw (IOException)pe.getException();
        }
    }

    private Hashtable<String, Object> parseStanzaTable(Vector<String> v) throws KrbException {
        if (v == null) {
            throw new KrbException("I/O error while reading configuration file.");
        }
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        block0: for (int i = 0; i < v.size(); ++i) {
            String line = v.elementAt(i).trim();
            if (line.equalsIgnoreCase("[realms]")) {
                for (int count = i + 1; count < v.size() + 1; ++count) {
                    if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                    Hashtable<Object, Object> temp = new Hashtable();
                    temp = this.parseRealmField(v, i + 1, count);
                    table.put("realms", temp);
                    i = count - 1;
                    continue block0;
                }
                continue;
            }
            if (line.equalsIgnoreCase("[capaths]")) {
                for (int count = i + 1; count < v.size() + 1; ++count) {
                    if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                    Hashtable<Object, Object> temp = new Hashtable();
                    temp = this.parseRealmField(v, i + 1, count);
                    table.put("capaths", temp);
                    i = count - 1;
                    continue block0;
                }
                continue;
            }
            if (!line.startsWith("[") || !line.endsWith("]")) continue;
            String key = line.substring(1, line.length() - 1);
            for (int count = i + 1; count < v.size() + 1; ++count) {
                if (count != v.size() && !v.elementAt(count).startsWith("[")) continue;
                Hashtable<String, String> temp = this.parseField(v, i + 1, count);
                table.put(key, temp);
                i = count - 1;
                continue block0;
            }
        }
        return table;
    }

    private String getFileName() {
        String name = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.conf"));
        if (name != null) {
            boolean temp = AccessController.doPrivileged(new FileExistsAction(name));
            if (temp) {
                return name;
            }
        } else {
            name = AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf";
            boolean temp = AccessController.doPrivileged(new FileExistsAction(name));
            if (temp) {
                return name;
            }
            String osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (osname.startsWith("Windows")) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception e) {
                    // empty catch block
                }
                name = Credentials.alreadyLoaded ? ((name = Config.getWindowsDirectory()) == null ? "c:\\winnt\\krb5.ini" : (name.endsWith("\\") ? name + "krb5.ini" : name + "\\krb5.ini")) : "c:\\winnt\\krb5.ini";
            } else if (osname.startsWith("SunOS")) {
                name = "/etc/krb5/krb5.conf";
            } else if (osname.startsWith("Linux")) {
                name = "/etc/krb5.conf";
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Config name: " + name));
        }
        return name;
    }

    private Hashtable<String, String> parseField(Vector<String> v, int start, int end) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        block0: for (int i = start; i < end; ++i) {
            String line = v.elementAt(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                String key = line.substring(0, j).trim();
                String value = line.substring(j + 1).trim();
                table.put(key, value);
                continue block0;
            }
        }
        return table;
    }

    private Hashtable<String, Hashtable<String, Vector<String>>> parseRealmField(Vector<String> v, int start, int end) {
        Hashtable<String, Hashtable<String, Vector<String>>> table = new Hashtable<String, Hashtable<String, Vector<String>>>();
        block0: for (int i = start; i < end; ++i) {
            String line = v.elementAt(i).trim();
            if (!line.endsWith("{")) continue;
            String key = "";
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                key = line.substring(0, j).trim();
                break;
            }
            for (int k = i + 1; k < end; ++k) {
                boolean found = false;
                line = v.elementAt(k).trim();
                for (int l = 0; l < line.length(); ++l) {
                    if (line.charAt(l) != '}') continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Hashtable<String, Vector<String>> temp = this.parseRealmFieldEx(v, i + 1, k);
                table.put(key, temp);
                i = k;
                found = false;
                continue block0;
            }
        }
        return table;
    }

    private Hashtable<String, Vector<String>> parseRealmFieldEx(Vector<String> v, int start, int end) {
        Hashtable<String, Vector<String>> table = new Hashtable<String, Vector<String>>();
        Vector<String> keyVector = new Vector<String>();
        Vector<Object> nameVector = new Vector();
        String line = "";
        block0: for (int i = start; i < end; ++i) {
            line = v.elementAt(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != '=') continue;
                String key = line.substring(0, j - 1).trim();
                if (!this.exists(key, keyVector)) {
                    keyVector.addElement(key);
                    nameVector = new Vector();
                } else {
                    nameVector = table.get(key);
                }
                nameVector.addElement(line.substring(j + 1).trim());
                table.put(key, nameVector);
                continue block0;
            }
        }
        return table;
    }

    private boolean exists(String key, Vector v) {
        boolean exists = false;
        for (int i = 0; i < v.size(); ++i) {
            if (!((String)v.elementAt(i)).equals(key)) continue;
            exists = true;
        }
        return exists;
    }

    public void listTable() {
        this.listTable(this.stanzaTable);
    }

    private void listTable(Hashtable table) {
        Vector v = new Vector();
        if (this.stanzaTable != null) {
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object object = table.get(key);
                if (table == this.stanzaTable) {
                    System.out.println("[" + key + "]");
                }
                if (object instanceof Hashtable) {
                    if (table != this.stanzaTable) {
                        System.out.println("\t" + key + " = {");
                    }
                    this.listTable((Hashtable)object);
                    if (table == this.stanzaTable) continue;
                    System.out.println("\t}");
                    continue;
                }
                if (object instanceof String) {
                    System.out.println("\t" + key + " = " + (String)table.get(key));
                    continue;
                }
                if (!(object instanceof Vector)) continue;
                v = (Vector)object;
                for (int i = 0; i < v.size(); ++i) {
                    System.out.println("\t" + key + " = " + (String)v.elementAt(i));
                }
            }
        } else {
            System.out.println("Configuration file not found.");
        }
    }

    public int[] defaultEtype(String enctypes) {
        int[] etype;
        String default_enctypes = this.getDefault(enctypes, "libdefaults");
        String delim = " ";
        if (default_enctypes == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using builtin default etypes for " + enctypes));
            }
            etype = EType.getBuiltInDefaults();
        } else {
            int i;
            for (int j = 0; j < default_enctypes.length(); ++j) {
                if (!default_enctypes.substring(j, j + 1).equals(",")) continue;
                delim = ",";
                break;
            }
            StringTokenizer st = new StringTokenizer(default_enctypes, delim);
            int len = st.countTokens();
            ArrayList<Integer> ls = new ArrayList<Integer>(len);
            for (i = 0; i < len; ++i) {
                int type = this.getType(st.nextToken());
                if (type == -1 || !EType.isSupported(type)) continue;
                ls.add(type);
            }
            if (ls.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no supported default etypes for " + enctypes));
                }
                return null;
            }
            etype = new int[ls.size()];
            for (i = 0; i < etype.length; ++i) {
                etype[i] = (Integer)ls.get(i);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("default etypes for " + enctypes + ":"));
            for (int i = 0; i < etype.length; ++i) {
                System.out.print(" " + etype[i]);
            }
            System.out.println(".");
        }
        return etype;
    }

    public int getType(String input) {
        int result = -1;
        if (input == null) {
            return result;
        }
        if (input.startsWith("d") || input.startsWith("D")) {
            if (input.equalsIgnoreCase("des-cbc-crc")) {
                result = 1;
            } else if (input.equalsIgnoreCase("des-cbc-md5")) {
                result = 3;
            } else if (input.equalsIgnoreCase("des-mac")) {
                result = 4;
            } else if (input.equalsIgnoreCase("des-mac-k")) {
                result = 5;
            } else if (input.equalsIgnoreCase("des-cbc-md4")) {
                result = 2;
            } else if (input.equalsIgnoreCase("des3-cbc-sha1") || input.equalsIgnoreCase("des3-hmac-sha1") || input.equalsIgnoreCase("des3-cbc-sha1-kd") || input.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                result = 16;
            }
        } else if (input.startsWith("a") || input.startsWith("A")) {
            if (input.equalsIgnoreCase("aes128-cts") || input.equalsIgnoreCase("aes128-cts-hmac-sha1-96")) {
                result = 17;
            } else if (input.equalsIgnoreCase("aes256-cts") || input.equalsIgnoreCase("aes256-cts-hmac-sha1-96")) {
                result = 18;
            } else if (input.equalsIgnoreCase("arcfour-hmac") || input.equalsIgnoreCase("arcfour-hmac-md5")) {
                result = 23;
            }
        } else if (input.equalsIgnoreCase("rc4-hmac")) {
            result = 23;
        } else if (input.equalsIgnoreCase("CRC32")) {
            result = 1;
        } else if (input.startsWith("r") || input.startsWith("R")) {
            if (input.equalsIgnoreCase("rsa-md5")) {
                result = 7;
            } else if (input.equalsIgnoreCase("rsa-md5-des")) {
                result = 8;
            }
        } else if (input.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            result = 12;
        } else if (input.equalsIgnoreCase("hmac-sha1-96-aes128")) {
            result = 15;
        } else if (input.equalsIgnoreCase("hmac-sha1-96-aes256")) {
            result = 16;
        } else if (input.equalsIgnoreCase("hmac-md5-rc4") || input.equalsIgnoreCase("hmac-md5-arcfour") || input.equalsIgnoreCase("hmac-md5-enc")) {
            result = -138;
        } else if (input.equalsIgnoreCase("NULL")) {
            result = 0;
        }
        return result;
    }

    public void resetDefaultRealm(String realm) {
        this.defaultRealm = realm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> Config reset default kdc " + this.defaultRealm));
        }
    }

    public boolean useAddresses() {
        boolean useAddr = false;
        String value = this.getDefault("no_addresses", "libdefaults");
        boolean bl = useAddr = value != null && value.equalsIgnoreCase("false");
        if (!useAddr) {
            value = this.getDefault("noaddresses", "libdefaults");
            useAddr = value != null && value.equalsIgnoreCase("false");
        }
        return useAddr;
    }

    public String getDefaultRealm() {
        return this.getDefault("default_realm", "libdefaults");
    }

    public String getKDCList(String realm) {
        String kdcs;
        if (realm == null) {
            realm = this.getDefaultRealm();
        }
        if ((kdcs = this.getDefault("kdc", realm)) == null) {
            return null;
        }
        return kdcs;
    }

    static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private String fileName;

        public FileExistsAction(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public Boolean run() {
            return new File(this.fileName).exists();
        }
    }
}

