/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.net.InetAddress;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Checksum;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.APOptions;
import sun.security.mule.krb5.internal.APReq;
import sun.security.mule.krb5.internal.Authenticator;
import sun.security.mule.krb5.internal.AuthorizationData;
import sun.security.mule.krb5.internal.EncTicketPart;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.KRBError;
import sun.security.mule.krb5.internal.KdcErrException;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.LocalSeqNumber;
import sun.security.mule.krb5.internal.SeqNumber;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.crypto.EType;
import sun.security.mule.krb5.internal.rcache.AuthTime;
import sun.security.mule.krb5.internal.rcache.CacheTable;
import sun.security.util.DerValue;

public class KrbApReq {
    private byte[] obuf;
    private KerberosTime ctime;
    private int cusec;
    private Authenticator authenticator;
    private Credentials creds;
    private APReq apReqMessg;
    private Config kerberosConfig;
    private static CacheTable table = new CacheTable();
    private static boolean DEBUG = Krb5.DEBUG;
    private boolean KDC_EMPTY_ADDRESSES_ALLOWED = true;

    public KrbApReq(Credentials tgsCred, boolean mutualRequired, boolean useSubKey, boolean useSeqNumber, Checksum cksum, Config kerberosConfig) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        APOptions apOptions;
        this.kerberosConfig = kerberosConfig;
        APOptions aPOptions = apOptions = mutualRequired ? new APOptions(2) : new APOptions();
        if (DEBUG) {
            System.out.println(">>> KrbApReq: APOptions are " + apOptions);
        }
        EncryptionKey subKey = useSubKey ? new EncryptionKey(tgsCred.getSessionKey()) : null;
        LocalSeqNumber seqNum = new LocalSeqNumber();
        this.init(apOptions, tgsCred, cksum, subKey, seqNum, null, 11);
    }

    public KrbApReq(byte[] message, EncryptionKey[] keys, InetAddress initiator, Config kerberosConfig) throws KrbException, IOException {
        this.kerberosConfig = kerberosConfig;
        this.obuf = message;
        if (this.apReqMessg == null) {
            this.decode();
        }
        this.authenticate(keys, initiator);
    }

    KrbApReq(APOptions apOptions, Ticket ticket, EncryptionKey key, Realm crealm, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, Config kerbConfig) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.kerberosConfig = kerbConfig;
        this.init(apOptions, ticket, key, crealm, cname, cksum, ctime, subKey, seqNumber, authorizationData, 7);
    }

    private void init(APOptions options, Credentials tgs_creds, Checksum cksum, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws KrbException, IOException {
        this.ctime = new KerberosTime(true, this.kerberosConfig);
        this.init(options, tgs_creds.ticket, tgs_creds.key, tgs_creds.client.getRealm(), tgs_creds.client, cksum, this.ctime, subKey, seqNumber, authorizationData, usage);
    }

    private void init(APOptions apOptions, Ticket ticket, EncryptionKey key, Realm crealm, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.createMessage(apOptions, ticket, key, crealm, cname, cksum, ctime, subKey, seqNumber, authorizationData, usage);
        this.obuf = this.apReqMessg.asn1Encode();
    }

    void decode() throws KrbException, IOException {
        DerValue encoding = new DerValue(this.obuf);
        this.decode(encoding);
    }

    void decode(DerValue encoding) throws KrbException, IOException {
        this.apReqMessg = null;
        try {
            this.apReqMessg = new APReq(encoding);
        }
        catch (Asn1Exception e) {
            this.apReqMessg = null;
            KRBError err = new KRBError(encoding, this.kerberosConfig);
            String errStr = err.getErrorString();
            String eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            KrbException ke = new KrbException(err.getErrorCode(), eText);
            ke.initCause(e);
            throw ke;
        }
    }

    private void authenticate(EncryptionKey[] keys, InetAddress initiator) throws KrbException, IOException {
        int encPartKeyType = this.apReqMessg.ticket.encPart.getEType();
        EncryptionKey dkey = EncryptionKey.findKey(encPartKeyType, keys);
        if (dkey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AP REP - " + EType.toString(encPartKeyType));
        }
        byte[] bytes = this.apReqMessg.ticket.encPart.decrypt(dkey, 2);
        byte[] temp = this.apReqMessg.ticket.encPart.reset(bytes, true);
        EncTicketPart enc_ticketPart = new EncTicketPart(temp, this.kerberosConfig);
        KrbApReq.checkPermittedEType(enc_ticketPart.key.getEType(), this.kerberosConfig);
        byte[] bytes2 = this.apReqMessg.authenticator.decrypt(enc_ticketPart.key, 11);
        byte[] temp2 = this.apReqMessg.authenticator.reset(bytes2, true);
        this.authenticator = new Authenticator(temp2, this.kerberosConfig);
        this.ctime = this.authenticator.ctime;
        this.cusec = this.authenticator.cusec;
        this.authenticator.ctime.setMicroSeconds(this.authenticator.cusec);
        this.authenticator.cname.setRealm(this.authenticator.crealm);
        this.apReqMessg.ticket.sname.setRealm(this.apReqMessg.ticket.realm);
        enc_ticketPart.cname.setRealm(enc_ticketPart.crealm);
        this.kerberosConfig.resetDefaultRealm(this.apReqMessg.ticket.realm.toString());
        if (!this.authenticator.cname.equals(enc_ticketPart.cname)) {
            throw new KrbApErrException(36);
        }
        KerberosTime currTime = new KerberosTime(true, this.kerberosConfig);
        if (!this.authenticator.ctime.inClockSkew(currTime)) {
            throw new KrbApErrException(37);
        }
        AuthTime time = new AuthTime(this.authenticator.ctime.getTime(), this.authenticator.cusec);
        String client = this.authenticator.cname.toString();
        if (table.get(time, this.authenticator.cname.toString()) != null) {
            throw new KrbApErrException(34);
        }
        table.put(client, time, currTime.getTime());
        if (this.kerberosConfig.useAddresses()) {
            this.KDC_EMPTY_ADDRESSES_ALLOWED = false;
        }
        HostAddress sender = null;
        if (initiator != null) {
            sender = new HostAddress(initiator);
        }
        if (!(sender == null && this.KDC_EMPTY_ADDRESSES_ALLOWED || enc_ticketPart.caddr == null)) {
            if (sender == null) {
                throw new KrbApErrException(38);
            }
            if (!enc_ticketPart.caddr.inList(sender)) {
                throw new KrbApErrException(38);
            }
        }
        KerberosTime now = new KerberosTime(true, this.kerberosConfig);
        if (enc_ticketPart.starttime != null && enc_ticketPart.starttime.greaterThanWRTClockSkew(now) || enc_ticketPart.flags.get(7)) {
            throw new KrbApErrException(33);
        }
        if (enc_ticketPart.endtime != null && now.greaterThanWRTClockSkew(enc_ticketPart.endtime)) {
            throw new KrbApErrException(32);
        }
        this.creds = new Credentials(this.apReqMessg.ticket, this.authenticator.cname, this.apReqMessg.ticket.sname, enc_ticketPart.key, null, enc_ticketPart.authtime, enc_ticketPart.starttime, enc_ticketPart.endtime, enc_ticketPart.renewTill, enc_ticketPart.caddr);
        if (DEBUG) {
            System.out.println(">>> KrbApReq: authenticate succeed.");
        }
    }

    public Credentials getCreds() {
        return this.creds;
    }

    KerberosTime getCtime() {
        if (this.ctime != null) {
            return this.ctime;
        }
        return this.authenticator.ctime;
    }

    int cusec() {
        return this.cusec;
    }

    APOptions getAPOptions() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions;
        }
        return null;
    }

    public boolean getMutualAuthRequired() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(2);
        }
        return false;
    }

    boolean useSessionKey() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(1);
        }
        return false;
    }

    public EncryptionKey getSubKey() {
        return this.authenticator.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.authenticator.getSeqNumber();
    }

    public Checksum getChecksum() {
        return this.authenticator.getChecksum();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public PrincipalName getClient() {
        return this.creds.getClient();
    }

    private void createMessage(APOptions apOptions, Ticket ticket, EncryptionKey key, Realm crealm, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer seqno = null;
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
        }
        this.authenticator = new Authenticator(crealm, cname, cksum, ctime.getMicroSeconds(), ctime, subKey, seqno, authorizationData, this.kerberosConfig);
        byte[] temp = this.authenticator.asn1Encode();
        EncryptedData encAuthenticator = new EncryptedData(key, temp, usage);
        this.apReqMessg = new APReq(apOptions, ticket, encAuthenticator);
    }

    private static void checkPermittedEType(int target, Config kerberosConfig) throws KrbException {
        int[] etypes = EType.getDefaults("permitted_enctypes", kerberosConfig);
        if (etypes == null) {
            throw new KrbException("No supported encryption types listed in permitted_enctypes");
        }
        if (!EType.isSupported(target, etypes)) {
            throw new KrbException(EType.toString(target) + " encryption type not in permitted_enctypes list");
        }
    }
}

