/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbTgsReq;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.EncKrbCredPart;
import sun.security.mule.krb5.internal.HostAddresses;
import sun.security.mule.krb5.internal.KDCOptions;
import sun.security.mule.krb5.internal.KRBCred;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbCredInfo;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.TicketFlags;
import sun.security.util.DerValue;

public class KrbCred {
    private static boolean DEBUG = Krb5.DEBUG;
    private byte[] obuf = null;
    private KRBCred credMessg = null;
    private Ticket ticket = null;
    private EncKrbCredPart encPart = null;
    private Credentials creds = null;
    private KerberosTime timeStamp = null;

    public KrbCred(Credentials tgt, Credentials serviceTicket, EncryptionKey key, Config kerberosConfig) throws KrbException, IOException {
        PrincipalName client = tgt.getClient();
        PrincipalName tgService = tgt.getServer();
        PrincipalName server = serviceTicket.getServer();
        if (!serviceTicket.getClient().equals(client)) {
            throw new KrbException(60, "Client principal does not match");
        }
        KDCOptions options = new KDCOptions(kerberosConfig);
        options.set(2, true);
        options.set(1, true);
        HostAddresses sAddrs = null;
        if (server.getNameType() == 3) {
            sAddrs = new HostAddresses(server);
        }
        KrbTgsReq tgsReq = new KrbTgsReq(options, tgt, tgService, null, null, null, null, sAddrs, null, null, null, kerberosConfig);
        this.credMessg = this.createMessage(tgsReq.sendAndGetCreds(), key, kerberosConfig);
        this.obuf = this.credMessg.asn1Encode();
    }

    KRBCred createMessage(Credentials delegatedCreds, EncryptionKey key, Config kerberosConfig) throws KrbException, IOException {
        EncryptionKey sessionKey = delegatedCreds.getSessionKey();
        PrincipalName princ = delegatedCreds.getClient();
        Realm realm = princ.getRealm();
        PrincipalName tgService = delegatedCreds.getServer();
        Realm tgsRealm = tgService.getRealm();
        KrbCredInfo credInfo = new KrbCredInfo(sessionKey, realm, princ, delegatedCreds.flags, delegatedCreds.authTime, delegatedCreds.startTime, delegatedCreds.endTime, delegatedCreds.renewTill, tgsRealm, tgService, delegatedCreds.cAddr, kerberosConfig);
        this.timeStamp = new KerberosTime(true, kerberosConfig);
        KrbCredInfo[] credInfos = new KrbCredInfo[]{credInfo};
        EncKrbCredPart encPart = new EncKrbCredPart(credInfos, this.timeStamp, null, null, null, null, kerberosConfig);
        EncryptedData encEncPart = new EncryptedData(key, encPart.asn1Encode(), 14);
        Ticket[] tickets = new Ticket[]{delegatedCreds.ticket};
        this.credMessg = new KRBCred(tickets, encEncPart);
        return this.credMessg;
    }

    public KrbCred(byte[] asn1Message, EncryptionKey key, Config kerberosConfig) throws KrbException, IOException {
        this.credMessg = new KRBCred(asn1Message);
        this.ticket = this.credMessg.tickets[0];
        byte[] temp = this.credMessg.encPart.decrypt(key, 14);
        byte[] plainText = this.credMessg.encPart.reset(temp, true);
        DerValue encoding = new DerValue(plainText);
        EncKrbCredPart encPart = new EncKrbCredPart(encoding, kerberosConfig);
        this.timeStamp = encPart.timeStamp;
        KrbCredInfo credInfo = encPart.ticketInfo[0];
        EncryptionKey credInfoKey = credInfo.key;
        Realm prealm = credInfo.prealm;
        PrincipalName pname = credInfo.pname;
        pname.setRealm(prealm);
        TicketFlags flags = credInfo.flags;
        KerberosTime authtime = credInfo.authtime;
        KerberosTime starttime = credInfo.starttime;
        KerberosTime endtime = credInfo.endtime;
        KerberosTime renewTill = credInfo.renewTill;
        Realm srealm = credInfo.srealm;
        PrincipalName sname = credInfo.sname;
        sname.setRealm(srealm);
        HostAddresses caddr = credInfo.caddr;
        if (DEBUG) {
            System.out.println(">>>Delegated Creds have pname=" + pname + " sname=" + sname + " authtime=" + authtime + " starttime=" + starttime + " endtime=" + endtime + "renewTill=" + renewTill);
        }
        this.creds = new Credentials(this.ticket, pname, sname, credInfoKey, flags, authtime, starttime, endtime, renewTill, caddr);
    }

    public Credentials[] getDelegatedCreds() {
        Credentials[] allCreds = new Credentials[]{this.creds};
        return allCreds;
    }

    public byte[] getMessage() {
        return this.obuf;
    }
}

