/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbAppMessage;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.EncKrbPrivPart;
import sun.security.mule.krb5.internal.HostAddress;
import sun.security.mule.krb5.internal.KRBPriv;
import sun.security.mule.krb5.internal.KdcErrException;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.SeqNumber;
import sun.security.util.DerValue;

class KrbPriv
extends KrbAppMessage {
    private byte[] obuf;
    private byte[] userData;
    private Config kerberosConfig;

    private KrbPriv(byte[] userData, Credentials creds, EncryptionKey subKey, KerberosTime timestamp, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr, Config kerberosConfig) throws KrbException, IOException {
        this.kerberosConfig = kerberosConfig;
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.obuf = this.mk_priv(userData, reqKey, timestamp, seqNumber, saddr, raddr);
    }

    private KrbPriv(byte[] msg, Credentials creds, EncryptionKey subKey, SeqNumber seqNumber, HostAddress saddr, HostAddress raddr, boolean timestampRequired, boolean seqNumberRequired, Config kerberosConfig) throws KrbException, IOException {
        this.kerberosConfig = kerberosConfig;
        KRBPriv krb_priv = new KRBPriv(msg);
        EncryptionKey reqKey = null;
        reqKey = subKey != null ? subKey : creds.key;
        this.userData = this.rd_priv(krb_priv, reqKey, seqNumber, saddr, raddr, timestampRequired, seqNumberRequired, creds.client, creds.client.getRealm());
    }

    public byte[] getMessage() throws KrbException {
        return this.obuf;
    }

    public byte[] getData() {
        return this.userData;
    }

    private byte[] mk_priv(byte[] userData, EncryptionKey key, KerberosTime timestamp, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer usec = null;
        Integer seqno = null;
        if (timestamp != null) {
            usec = new Integer(timestamp.getMicroSeconds());
        }
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
            seqNumber.step();
        }
        EncKrbPrivPart unenc_encKrbPrivPart = new EncKrbPrivPart(userData, timestamp, usec, seqno, sAddress, rAddress, this.kerberosConfig);
        byte[] temp = unenc_encKrbPrivPart.asn1Encode();
        EncryptedData encKrbPrivPart = new EncryptedData(key, temp, 13);
        KRBPriv krb_priv = new KRBPriv(encKrbPrivPart);
        temp = krb_priv.asn1Encode();
        return krb_priv.asn1Encode();
    }

    private byte[] rd_priv(KRBPriv krb_priv, EncryptionKey key, SeqNumber seqNumber, HostAddress sAddress, HostAddress rAddress, boolean timestampRequired, boolean seqNumberRequired, PrincipalName cname, Realm crealm) throws Asn1Exception, KdcErrException, KrbApErrException, IOException, KrbCryptoException {
        byte[] bytes = krb_priv.encPart.decrypt(key, 13);
        byte[] temp = krb_priv.encPart.reset(bytes, true);
        DerValue ref = new DerValue(temp);
        EncKrbPrivPart enc_part = new EncKrbPrivPart(ref, this.kerberosConfig);
        this.check(enc_part.timestamp, enc_part.usec, enc_part.seqNumber, enc_part.sAddress, enc_part.rAddress, seqNumber, sAddress, rAddress, timestampRequired, seqNumberRequired, cname, crealm);
        return enc_part.userData;
    }
}

