/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Checksum;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.Credentials;
import sun.security.mule.krb5.EncryptedData;
import sun.security.mule.krb5.EncryptionKey;
import sun.security.mule.krb5.KrbApReq;
import sun.security.mule.krb5.KrbCryptoException;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.KrbKdcReq;
import sun.security.mule.krb5.KrbTgsRep;
import sun.security.mule.krb5.PrincipalName;
import sun.security.mule.krb5.Realm;
import sun.security.mule.krb5.internal.APOptions;
import sun.security.mule.krb5.internal.AuthorizationData;
import sun.security.mule.krb5.internal.HostAddresses;
import sun.security.mule.krb5.internal.KDCOptions;
import sun.security.mule.krb5.internal.KDCReqBody;
import sun.security.mule.krb5.internal.KdcErrException;
import sun.security.mule.krb5.internal.KerberosTime;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.mule.krb5.internal.KrbApErrException;
import sun.security.mule.krb5.internal.PAData;
import sun.security.mule.krb5.internal.TGSReq;
import sun.security.mule.krb5.internal.Ticket;
import sun.security.mule.krb5.internal.crypto.EType;
import sun.security.mule.krb5.internal.crypto.Nonce;

public class KrbTgsReq
extends KrbKdcReq {
    private PrincipalName princName;
    private PrincipalName servName;
    private TGSReq tgsReqMessg;
    private KerberosTime ctime;
    private Ticket secondTicket = null;
    private boolean useSubkey = false;
    EncryptionKey tgsReqKey;
    private Config kerberosConfig;
    private static final boolean DEBUG = Krb5.DEBUG;
    private int defaultTimeout = 30000;

    public KrbTgsReq(Credentials asCreds, PrincipalName sname, Config kerberosConfig) throws KrbException, IOException {
        this(new KDCOptions(kerberosConfig), asCreds, sname, null, null, null, null, null, null, null, null, kerberosConfig);
    }

    KrbTgsReq(KDCOptions options, Credentials asCreds, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, AuthorizationData authorizationData, Ticket[] additionalTickets, EncryptionKey subKey, Config kerberosConfig) throws KrbException, IOException {
        this.princName = asCreds.client;
        this.servName = sname;
        this.ctime = new KerberosTime(true, kerberosConfig);
        this.kerberosConfig = kerberosConfig;
        if (options.get(1) && !asCreds.flags.get(1)) {
            throw new KrbException(101);
        }
        if (options.get(2) && !asCreds.flags.get(1)) {
            throw new KrbException(101);
        }
        if (options.get(3) && !asCreds.flags.get(3)) {
            throw new KrbException(101);
        }
        if (options.get(4) && !asCreds.flags.get(3)) {
            throw new KrbException(101);
        }
        if (options.get(5) && !asCreds.flags.get(5)) {
            throw new KrbException(101);
        }
        if (options.get(8) && !asCreds.flags.get(8)) {
            throw new KrbException(101);
        }
        if (options.get(6)) {
            if (!asCreds.flags.get(6)) {
                throw new KrbException(101);
            }
        } else if (from != null) {
            from = null;
        }
        if (options.get(8)) {
            if (!asCreds.flags.get(8)) {
                throw new KrbException(101);
            }
        } else if (rtime != null) {
            rtime = null;
        }
        if (options.get(28)) {
            if (additionalTickets == null) {
                throw new KrbException(101);
            }
            this.secondTicket = additionalTickets[0];
        } else if (additionalTickets != null) {
            additionalTickets = null;
        }
        this.tgsReqMessg = this.createRequest(options, asCreds.ticket, asCreds.key, this.ctime, this.princName, this.princName.getRealm(), this.servName, from, till, rtime, eTypes, addresses, authorizationData, additionalTickets, subKey);
        this.obuf = this.tgsReqMessg.asn1Encode();
        if (asCreds.flags.get(2)) {
            options.set(2, true);
        }
    }

    public String send() throws IOException, KrbException {
        String realmStr = null;
        if (this.servName != null) {
            realmStr = this.servName.getRealmString();
        }
        return this.send(realmStr, this.kerberosConfig);
    }

    public KrbTgsRep getReply() throws KrbException, IOException {
        return new KrbTgsRep(this.ibuf, this, this.kerberosConfig);
    }

    public Credentials sendAndGetCreds() throws IOException, KrbException {
        KrbTgsRep tgs_rep = null;
        String kdc = null;
        try {
            kdc = this.send();
            tgs_rep = this.getReply();
        }
        catch (KrbException ke) {
            if (ke.returnCode() == 52) {
                this.send(this.servName.getRealmString(), kdc, true, this.kerberosConfig);
                tgs_rep = this.getReply();
            }
            throw ke;
        }
        return tgs_rep.getCreds();
    }

    KerberosTime getCtime() {
        return this.ctime;
    }

    private TGSReq createRequest(KDCOptions kdc_options, Ticket ticket, EncryptionKey key, KerberosTime ctime, PrincipalName cname, Realm crealm, PrincipalName sname, KerberosTime from, KerberosTime till, KerberosTime rtime, int[] eTypes, HostAddresses addresses, AuthorizationData authorizationData, Ticket[] additionalTickets, EncryptionKey subKey) throws Asn1Exception, IOException, KdcErrException, KrbApErrException, UnknownHostException, KrbCryptoException {
        Checksum cksum;
        KerberosTime req_till = null;
        req_till = till == null ? new KerberosTime(this.kerberosConfig) : till;
        this.tgsReqKey = key;
        int[] req_eTypes = null;
        if (eTypes == null) {
            req_eTypes = EType.getDefaults("default_tgs_enctypes", this.kerberosConfig);
            if (req_eTypes == null) {
                throw new KrbCryptoException("No supported encryption types listed in default_tgs_enctypes");
            }
        } else {
            req_eTypes = eTypes;
        }
        EncryptionKey reqKey = null;
        EncryptedData encAuthorizationData = null;
        if (authorizationData != null) {
            byte[] ad = authorizationData.asn1Encode();
            if (subKey != null) {
                reqKey = subKey;
                this.tgsReqKey = subKey;
                this.useSubkey = true;
                encAuthorizationData = new EncryptedData(reqKey, ad, 5);
            } else {
                encAuthorizationData = new EncryptedData(key, ad, 4);
            }
        }
        KDCReqBody reqBody = new KDCReqBody(kdc_options, cname, sname.getRealm(), sname, from, req_till, rtime, Nonce.value(), req_eTypes, addresses, encAuthorizationData, additionalTickets, this.kerberosConfig);
        byte[] temp = reqBody.asn1Encode(12);
        switch (Checksum.getChecksumdefault(this.kerberosConfig)) {
            case -138: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                cksum = new Checksum(-999, temp, key, 6, this.kerberosConfig);
                break;
            }
            default: {
                cksum = new Checksum(-999, temp, this.kerberosConfig);
            }
        }
        byte[] tgs_ap_req = new KrbApReq(new APOptions(), ticket, key, crealm, cname, cksum, ctime, reqKey, null, null, this.kerberosConfig).getMessage();
        PAData[] tgsPAData = new PAData[]{new PAData(1, tgs_ap_req)};
        return new TGSReq(tgsPAData, reqBody);
    }

    TGSReq getMessage() {
        return this.tgsReqMessg;
    }

    Ticket getSecondTicket() {
        return this.secondTicket;
    }

    private static void debug(String message) {
    }

    boolean usedSubkey() {
        return this.useSubkey;
    }
}

