/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5;

import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.mule.krb5.Asn1Exception;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.KrbException;
import sun.security.mule.krb5.RealmException;
import sun.security.mule.krb5.internal.Krb5;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Realm
implements Cloneable {
    private String realm;
    private static boolean DEBUG = Krb5.DEBUG;

    private Realm() {
    }

    public Realm(String name) throws RealmException {
        this.realm = Realm.parseRealm(name);
    }

    public Object clone() {
        Realm new_realm = new Realm();
        if (this.realm != null) {
            new_realm.realm = new String(this.realm);
        }
        return new_realm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Realm)) {
            return false;
        }
        Realm that = (Realm)obj;
        if (this.realm != null && that.realm != null) {
            return this.realm.equals(that.realm);
        }
        return this.realm == null && that.realm == null;
    }

    public int hashCode() {
        int result = 17;
        if (this.realm != null) {
            result = 37 * result + this.realm.hashCode();
        }
        return result;
    }

    public Realm(DerValue encoding) throws Asn1Exception, RealmException, IOException {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding can not be null");
        }
        this.realm = encoding.getGeneralString();
        if (this.realm == null || this.realm.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(this.realm)) {
            throw new RealmException(600);
        }
    }

    public String toString() {
        return this.realm;
    }

    public static String parseRealmAtSeparator(String name) throws RealmException {
        if (name == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String temp = new String(name);
        String result = null;
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '@' || i != 0 && temp.charAt(i - 1) == '\\') continue;
            if (i + 1 >= temp.length()) break;
            result = temp.substring(i + 1, temp.length());
            break;
        }
        if (result != null) {
            if (result.length() == 0) {
                throw new RealmException(601);
            }
            if (!Realm.isValidRealmString(result)) {
                throw new RealmException(600);
            }
        }
        return result;
    }

    protected static String parseRealm(String name) throws RealmException {
        String result = Realm.parseRealmAtSeparator(name);
        if (result == null) {
            result = name;
        }
        if (result == null || result.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(result)) {
            throw new RealmException(600);
        }
        return result;
    }

    protected static boolean isValidRealmString(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '/' && name.charAt(i) != ':' && name.charAt(i) != '\u0000') continue;
            return false;
        }
        return true;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream out = new DerOutputStream();
        out.putGeneralString(this.realm);
        return out.toByteArray();
    }

    public static Realm parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException, RealmException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Realm(subDer);
    }

    private static String[] doInitialParse(String cRealm, String sRealm) throws KrbException {
        if (cRealm == null || sRealm == null) {
            throw new KrbException(400);
        }
        if (DEBUG) {
            System.out.println(">>> Realm doInitialParse: cRealm=[" + cRealm + "], sRealm=[" + sRealm + "]");
        }
        if (cRealm.equals(sRealm)) {
            String[] retList = null;
            retList = new String[]{new String(cRealm)};
            if (DEBUG) {
                System.out.println(">>> Realm doInitialParse: " + retList[0]);
            }
            return retList;
        }
        return null;
    }

    public static String[] getRealmsList(String cRealm, String sRealm, Config kerberosConfig) throws KrbException {
        String[] retList = Realm.doInitialParse(cRealm, sRealm);
        if (retList != null && retList.length != 0) {
            return retList;
        }
        retList = Realm.parseCapaths(cRealm, sRealm, kerberosConfig);
        if (retList != null && retList.length != 0) {
            return retList;
        }
        retList = Realm.parseHierarchy(cRealm, sRealm);
        return retList;
    }

    private static String[] parseCapaths(String cRealm, String sRealm, Config kerberosConfig) throws KrbException {
        String[] retList = null;
        String intermediaries = kerberosConfig.getDefault(sRealm, cRealm);
        if (intermediaries == null) {
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: no cfg entry");
            }
            return null;
        }
        String tempTarget = null;
        String tempRealm = null;
        StringTokenizer strTok = null;
        Stack<String> iStack = new Stack<String>();
        Vector<String> tempList = new Vector<String>(8, 8);
        tempList.add(cRealm);
        int count = 0;
        if (DEBUG) {
            tempTarget = sRealm;
        }
        while (true) {
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + ++count + ": target=" + tempTarget);
            }
            if (intermediaries != null && !intermediaries.equals(".")) {
                if (DEBUG) {
                    System.out.println(">>> Realm parseCapaths: loop " + count + ": intermediaries=[" + intermediaries + "]");
                }
                strTok = new StringTokenizer(intermediaries, " ");
                while (strTok.hasMoreTokens()) {
                    tempRealm = strTok.nextToken();
                    if (!tempRealm.equals(".") && !iStack.contains(tempRealm)) {
                        iStack.push(tempRealm);
                        if (!DEBUG) continue;
                        System.out.println(">>> Realm parseCapaths: loop " + count + ": pushed realm on to stack: " + tempRealm);
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println(">>> Realm parseCapaths: loop " + count + ": ignoring realm: [" + tempRealm + "]");
                }
            } else if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + count + ": no intermediaries");
            }
            try {
                tempTarget = (String)iStack.pop();
            }
            catch (EmptyStackException exc) {
                tempTarget = null;
            }
            if (tempTarget == null) break;
            tempList.add(tempTarget);
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: loop " + count + ": added intermediary to list: " + tempTarget);
            }
            intermediaries = kerberosConfig.getDefault(tempTarget, cRealm);
        }
        retList = new String[tempList.size()];
        try {
            retList = tempList.toArray(retList);
        }
        catch (ArrayStoreException exc) {
            retList = null;
        }
        if (DEBUG && retList != null) {
            for (int i = 0; i < retList.length; ++i) {
                System.out.println(">>> Realm parseCapaths [" + i + "]=" + retList[i]);
            }
        }
        return retList;
    }

    private static String[] parseHierarchy(String cRealm, String sRealm) throws KrbException {
        String[] retList = null;
        String[] cComponents = null;
        String[] sComponents = null;
        StringTokenizer strTok = new StringTokenizer(cRealm, ".");
        int cCount = strTok.countTokens();
        cComponents = new String[cCount];
        cCount = 0;
        while (strTok.hasMoreTokens()) {
            cComponents[cCount] = strTok.nextToken();
            ++cCount;
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: cRealm has " + cCount + " components:");
            int j = 0;
            while (j < cCount) {
                System.out.println(">>> Realm parseHierarchy: cComponents[" + j + "]=" + cComponents[j++]);
            }
        }
        strTok = new StringTokenizer(sRealm, ".");
        int sCount = strTok.countTokens();
        sComponents = new String[sCount];
        sCount = 0;
        while (strTok.hasMoreTokens()) {
            sComponents[sCount] = strTok.nextToken();
            ++sCount;
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: sRealm has " + sCount + " components:");
            int j = 0;
            while (j < sCount) {
                System.out.println(">>> Realm parseHierarchy: sComponents[" + j + "]=" + sComponents[j++]);
            }
        }
        int commonComponents = 0;
        --sCount;
        --cCount;
        while (sCount >= 0 && cCount >= 0 && sComponents[sCount].equals(cComponents[cCount])) {
            ++commonComponents;
            --sCount;
            --cCount;
        }
        int cCommonStart = -1;
        int sCommonStart = -1;
        int links = 0;
        if (commonComponents > 0) {
            sCommonStart = sCount + 1;
            cCommonStart = cCount + 1;
            links += sCommonStart;
            links += cCommonStart;
        } else {
            ++links;
        }
        if (DEBUG) {
            if (commonComponents > 0) {
                System.out.println(">>> Realm parseHierarchy: " + commonComponents + " common component" + (commonComponents > 1 ? "s" : " "));
                System.out.println(">>> Realm parseHierarchy: common part in cRealm (starts at index " + cCommonStart + ")");
                System.out.println(">>> Realm parseHierarchy: common part in sRealm (starts at index " + sCommonStart + ")");
                String commonPart = Realm.substring(cRealm, cCommonStart);
                System.out.println(">>> Realm parseHierarchy: common part in cRealm=" + commonPart);
                commonPart = Realm.substring(sRealm, sCommonStart);
                System.out.println(">>> Realm parseHierarchy: common part in sRealm=" + commonPart);
            } else {
                System.out.println(">>> Realm parseHierarchy: no common part");
            }
        }
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy: total links=" + links);
        }
        retList = new String[links];
        retList[0] = new String(cRealm);
        if (DEBUG) {
            System.out.println(">>> Realm parseHierarchy A: retList[0]=" + retList[0]);
        }
        Object cTemp = null;
        String sTemp = null;
        int i = 1;
        for (cCount = 0; i < links && cCount < cCommonStart; ++cCount) {
            sTemp = Realm.substring(cRealm, cCount + 1);
            retList[i++] = new String(sTemp);
            if (!DEBUG) continue;
            System.out.println(">>> Realm parseHierarchy B: retList[" + (i - 1) + "]=" + retList[i - 1]);
        }
        sCount = sCommonStart;
        while (i < links && sCount - 1 > 0) {
            sTemp = Realm.substring(sRealm, sCount - 1);
            retList[i++] = new String(sTemp);
            if (DEBUG) {
                System.out.println(">>> Realm parseHierarchy D: retList[" + (i - 1) + "]=" + retList[i - 1]);
            }
            --sCount;
        }
        return retList;
    }

    private static String substring(String realm, int componentIndex) {
        int i = 0;
        int j = 0;
        int len = realm.length();
        while (i < len && j != componentIndex) {
            if (realm.charAt(i++) != '.') continue;
            ++j;
        }
        return realm.substring(i);
    }

    static int getRandIndex(int arraySize) {
        return (int)(Math.random() * 16384.0) % arraySize;
    }

    static void printNames(String[] names) {
        if (names == null || names.length == 0) {
            return;
        }
        int len = names.length;
        System.out.println("List length = " + len);
        for (int i = 0; i < names.length; ++i) {
            System.out.println("[" + i + "]=" + names[i]);
        }
    }
}

