/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mule.krb5.cxf;

import java.net.URL;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.auth.HttpAuthSupplier;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.ietf.jgss.GSSException;
import sun.security.mule.krb5.Config;
import sun.security.mule.krb5.cxf.SpnegoTokenContext;

public class MuleSpnegoAuthSupplier
implements HttpAuthSupplier {
    private static final Log LOG = LogFactory.getLog(MuleSpnegoAuthSupplier.class);
    private byte[] token;
    private SpnegoTokenContext spnegoTokenContext;

    public boolean requiresRequestCaching() {
        return false;
    }

    public String getAuthorization(AuthorizationPolicy authPolicy, URL currentURL, Message message, String fullHeader) {
        if (!"Negotiate".equals(authPolicy.getAuthorizationType())) {
            return null;
        }
        String spn = "HTTP/" + currentURL.getHost();
        LOG.debug((Object)("Adding authorization service ticket for service principal name: " + spn));
        this.token = this.issueToken(message);
        return "Negotiate " + Base64Utility.encode((byte[])this.token);
    }

    private byte[] issueToken(Message message) {
        Config kerberosConfig = (Config)message.get((Object)"sun.security.mule.krb5.configuration");
        if (kerberosConfig == null) {
            String msg = "Cannot find a Kerberos config in the request of the message. Key:sun.security.mule.krb5.configuration";
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        if (kerberosConfig.getKerberosContext() == null) {
            String kerberosSpn = (String)message.getContextualProperty("ws-security.kerberos.spn");
            CallbackHandler callbackHandler = (CallbackHandler)message.getContextualProperty("ws-security.callback-handler");
            this.spnegoTokenContext = this.spnegoTokenContext != null ? this.spnegoTokenContext : new SpnegoTokenContext();
            Object spnegoClientAction = message.getContextualProperty("ws-security.spnego.client.action");
            if (spnegoClientAction instanceof SpnegoClientAction) {
                this.spnegoTokenContext.setSpnegoClientAction((SpnegoClientAction)spnegoClientAction);
            }
            this.spnegoTokenContext.setKerberosConfig(kerberosConfig);
            try {
                this.spnegoTokenContext.retrieveServiceTicket(callbackHandler, kerberosSpn);
            }
            catch (WSSecurityException e) {
                throw new Fault((Throwable)e);
            }
            return this.spnegoTokenContext.getToken();
        }
        byte[] token = new byte[]{};
        try {
            kerberosConfig.getKerberosContext().resetStateToInProgress();
            return kerberosConfig.getKerberosContext().initSecContext(token, 0, token.length);
        }
        catch (GSSException e) {
            throw new RuntimeException("cannot generate new AP_REQ", e);
        }
    }
}

